﻿using Curse;
using Curse.WAR;
using System;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
namespace WARDataService
{

    public static partial class DBItemSets
    {

        private const Byte NUM_PIECES = 8;

        private static HashSet<CustomKey> sKnownItemSets =
            new HashSet<CustomKey>(new CustomKey.CustomKeyComparer());

        private static Dictionary<CustomKey, DateTime> sItemSetExpirations =
            new Dictionary<CustomKey, DateTime>(new CustomKey.CustomKeyComparer());

        private static Dictionary<CustomKey, Confirmation> sItemSetConfirmations =
            new Dictionary<CustomKey, Confirmation>(new CustomKey.CustomKeyComparer());
        
        private static String sUpdateQuery = null;
        private static String sInsertQuery = null;

        private static String[] sUpdateIgnoredColumns = { "id", "posted", "posted_id", "version_id", "name" };
        private static String[] sIgnoreInsertColumns = {"id"};
        private static Dictionary<String, String> sUpdateCustomColumns = new Dictionary<string, string>();

                
        private static DataTable sItemSetSchema = null;        
        private static DataTable sItemSetBonusSchema = null;

        public static void Initialize()
        {            
            sItemSetExpirations.Clear();


            foreach (Int32 version in Config.Instance.Versions)
            {
                DB.PopulateId(sKnownItemSets, "itemset", version);
            }

            DB.LoadSchema(ref sItemSetSchema, "itemset");
            DB.LoadSchema(ref sItemSetBonusSchema, "itemset_bonus");

            sInsertQuery = DB.GetInsertSQL(sItemSetSchema, sIgnoreInsertColumns);

            for(Byte i=0;i<NUM_PIECES;i++)
            {
                String colName = "item_id"+i;
                sUpdateCustomColumns.Add(colName, "itemset."+colName+"=COALESCE(tmp."+colName+",tmp."+colName+",itemset."+colName+")");
            }

            sUpdateQuery = "update itemset set ";
            sUpdateQuery = sUpdateQuery + DB.GetUpdateSQL(sItemSetSchema, sUpdateIgnoredColumns, sUpdateCustomColumns);
            sUpdateQuery = sUpdateQuery + " FROM itemset,#itemset tmp" +
                " WHERE itemset.id=tmp.id and itemset.version_id=tmp.version_id;";

        }

        public static void Save(Update pUpdate, SqlConnection pConn)
        {

            if (pUpdate.ItemSets.Count == 0)
            {
                return;
            }

            StringBuilder sql = new StringBuilder();
            DataRow dr = null;
            DataTable dtInsert = sItemSetSchema.Clone();            
            DataTable dtUpdate = sItemSetSchema.Clone();
            DataTable dtBonusInsert = sItemSetBonusSchema.Clone();

            dtInsert.BeginLoadData();
            dtUpdate.BeginLoadData();
            dtBonusInsert.BeginLoadData();

            CustomKey key;
            String locale = pUpdate.Language.ToString();         
                        
           
            bool isNewRow = false;
            Int32 npcId = 0;
            String deleteSql = "";            
            foreach (ItemSet itemSet in pUpdate.ItemSets)
            {

                if (itemSet.Pieces.Count == 0 || !itemSet.Pieces.Exists(delegate(ItemSetPiece x) { return (x.Id>= 0); }))
                {
                    continue;
                }
                

                if (!DB.ReadyForDB(sItemSetExpirations,
                            sItemSetConfirmations,
                            itemSet.Id,
                            Config.Instance.ItemExpiration,
                            Config.Instance.MinConfirmations,
                            pUpdate.UserId,
                            pUpdate.ClientVersion.Value,
                            (ELocale)pUpdate.Language,
                            pUpdate.IsTrustedUser))
                {
                    continue;
                }

                key = new CustomKey(pUpdate.ClientVersion.Value,
                                  itemSet.Id);

                isNewRow = !sKnownItemSets.Contains(key);
                if (isNewRow)
                {
                    dr = dtInsert.NewRow();
                }
                else
                {
                    dr = dtUpdate.NewRow();
                }
                                                       
                dr["version_id"] = pUpdate.ClientVersion.Value;
                dr["id"] = itemSet.Id;
                dr["name_" + locale] = itemSet.Name;

                itemSet.Pieces.Sort(delegate(ItemSetPiece x, ItemSetPiece y)
                {
                    return x.Index.CompareTo(y.Index);
                });

                
                for (Byte i  = 0; i < NUM_PIECES; i++)
                {
                    if (i < itemSet.Pieces.Count)
                    {
                        dr["item_name_" + pUpdate.Language + i] = itemSet.Pieces[i].Name;
                        if (itemSet.Pieces[i].Id > 0)
                        {
                            dr["item_id" + i] = itemSet.Pieces[i].Id;
                        }
                    }
                    else
                    {
                        dr["item_id" + i] = 0;
                    }

                    
                }
                
                // Meta Data
                dr["updated_id"] = pUpdate.UserId;
                dr["posted_id"] = pUpdate.UserId;
                dr["posted"] = DateTime.UtcNow;
                dr["updated"] = DateTime.UtcNow;

                if (isNewRow)
                {
                    dtInsert.Rows.Add(dr);
                    sKnownItemSets.Add(key);
                }
                else
                {
                    dtUpdate.Rows.Add(dr);
                }

                if (itemSet.Bonuses.Count > 0)
                {
                    deleteSql += " or (itemset_id=" + itemSet.Id + " and version_id = " + pUpdate.ClientVersion.Value + ")";

                    foreach (ItemSetBonus bonus in itemSet.Bonuses)
                    {
                        DataRow bonusRow = dtBonusInsert.NewRow();
                        bonusRow["itemset_id"] = itemSet.Id;
                        bonusRow["version_id"] = pUpdate.ClientVersion.Value;
                        bonusRow["rank_type"] = bonus.RankType;
                        bonusRow["stat_type"] = bonus.StatType;
                        bonusRow["stat_value"] = bonus.StatValue;
                        bonusRow["pieces_required"] = bonus.PiecesRequired;

                        dtBonusInsert.Rows.Add(bonusRow);
                    }                   
                }
            }


            SqlCommand cmd = pConn.CreateCommand();

            if (dtInsert.Rows.Count > 0)
            {

                using (SqlBulkCopy bulk = new SqlBulkCopy(pConn,
                                                     SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                     null))
                {
                    bulk.DestinationTableName = "itemset";
                    bulk.BatchSize = 5000;
                    bulk.WriteToServer(dtInsert);                    
                }

            }

            if (dtBonusInsert.Rows.Count > 0)
            {
                cmd.CommandText = "delete from itemset_bonus where " + deleteSql.Substring(4);
                cmd.ExecuteNonQuery();

                using (SqlBulkCopy bulk = new SqlBulkCopy(pConn,
                                                    SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                    null))
                {
                    bulk.BatchSize = 5000;
                    bulk.DestinationTableName = "itemset_bonus";
                    bulk.WriteToServer(dtBonusInsert);
                    bulk.Close();
                }
                
            }                       
            
            if (dtUpdate.Rows.Count > 0)
            {

                cmd.CommandText = "SELECT TOP 0 * INTO #itemset FROM itemset;";
                cmd.ExecuteNonQuery();
                using (SqlBulkCopy bulk = new SqlBulkCopy(pConn,
                                                     SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                     null))
                {
                    bulk.BatchSize = 5000;
                    bulk.DestinationTableName = "#itemset";
                    bulk.WriteToServer(dtUpdate);
                    bulk.Close();
                }
                
                cmd.CommandText = String.Format(sUpdateQuery, locale);
                cmd.ExecuteNonQuery();
                cmd.CommandText = "DROP TABLE #itemset;";
                cmd.ExecuteNonQuery();
            }
                        

        }
    }
    
}
