﻿using Curse;
using Curse.WAR;
using System;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Data;
using System.Linq;
namespace WARDataService
{
    public static partial class DBPlayers
    {
        private const Byte NUM_TRADESKILLS = 2;
        private const Byte NUM_STATS = 21;

        private static String sUpdateQuery = null;
        private static String sInsertQuery = null;

        private static Dictionary<CustomKey, Int32> sPlayerNameToId = new Dictionary<CustomKey, Int32>(new CustomKey.CustomKeyComparer());

        // Removed the owner id from here: "owner_id", for now.
        private static String[] sUpdateIgnoredColumns = { "id", "name", "server_id", "posted" };
        private static String[] sIgnoreInsertColumns = { "id" };

        private static Dictionary<String, String> sUpdateCustomColumns = new Dictionary<string, string>();

        private static String sDeleteQuery = "DELETE player_loot_history FROM (select top((SELECT DBO.HIGHEST(0,{0} + COUNT(0) - 10) FROM player_loot_history WHERE player_id={1})) * from player_loot_history order by posted) as t1 WHERE player_loot_history.player_id = t1.player_id and player_loot_history.item_id = t1.item_id;";
        private static String sPlayerRecentItemInsertQueryFormat = "UPDATE player_loot_history SET posted=GETUTCDATE()" +
                                                                    " WHERE player_id={0} AND item_id={1}" +
                                                                    " IF @@ROWCOUNT = 0 " +
                                                                    "INSERT INTO player_loot_history(" +
                                                                    "player_id,item_id) VALUES({0},{1});";


        private static String sTempTableCreation = "SELECT TOP 0 * INTO #player FROM player;ALTER TABLE #player DROP COLUMN id;ALTER TABLE #player ADD id int;";
        private static DataTable sPlayerUpdateSchema = null;
        private static DataTable sPlayerInsertSchema = null;
        private static DataTable sPlayerEquipmentSchema = null;
        private static DataTable sPlayerInfluenceSchema = null;
        private static DataTable sPlayerTitleSchema = null;
        private static DataTable sPlayerAchievementSchema = null;
        

        public static void Initialize()
        {
            sUpdateCustomColumns.Clear();
            sPlayerNameToId.Clear();

            PopulatePlayerNameToID();

            DB.LoadSchema(ref sPlayerUpdateSchema, "#player", sTempTableCreation);
            DB.LoadSchema(ref sPlayerInsertSchema, "player");
            DB.LoadSchema(ref sPlayerEquipmentSchema, "player_equipment");
            DB.LoadSchema(ref sPlayerInfluenceSchema, "player_influence");
            DB.LoadSchema(ref sPlayerTitleSchema, "player_title");
            DB.LoadSchema(ref sPlayerAchievementSchema, "player_achievement");

            sInsertQuery = DB.GetInsertSQL(sPlayerInsertSchema, sIgnoreInsertColumns);

            sUpdateQuery = "update player set ";
            sUpdateQuery = sUpdateQuery + DB.GetUpdateSQL(sPlayerUpdateSchema, sUpdateIgnoredColumns, sUpdateCustomColumns);
            sUpdateQuery = sUpdateQuery + " FROM player,#player tmp" +
                " WHERE player.id=tmp.id;";

        }

        private static void PopulatePlayerNameToID()
        {                        
            String query = "select id, server_id, name from player with(nolock)";
            
            Int32 id;
            Int32 serverId;
            Int32 count = 0;
            using (SqlConnection conn = new SqlConnection(Config.Instance.ConnectionString))
            {
                conn.Open();

                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = query;
                using (SqlDataReader dr = cmd.ExecuteReader())
                {
                    while (dr.Read())
                    {
                        AddPlayer((String)dr[2], (Int32)dr[1], (Int32)dr[0]);                        
                        ++count;
                    }
                }
            }
            Logger.Log(ELogLevel.Debug,
                       null,
                       "Populated {0} names from table player",
                       count);
        }

        public static Int32 GetPlayerId(String pPlayerName, Int32 pServerId)
        {
            CustomKey key = GetPlayerKey(pPlayerName, pServerId);
            return DB.GetIdFromName(sPlayerNameToId, key);
        }

        public static void AddPlayer(String pPlayerName, Int32 pServerId, Int32 pPlayerId)
        {
            CustomKey key = GetPlayerKey(pPlayerName, pServerId);
            DB.AddNameFromId(sPlayerNameToId, key, pPlayerId);            
        }

        public static CustomKey GetPlayerKey(String pPlayerName, Int32 pServerId)
        {
            return new CustomKey(pPlayerName.ToLower(), pServerId);
        }


        public static void SetLootHistorySql(ref String pSql, PackableInt32List pLootHistory, Int32 pPlayerId)
        {
            pSql = pSql + String.Format(sDeleteQuery, pLootHistory.Count, pPlayerId);
            foreach (Int32 itemId in pLootHistory)
            {
                pSql = pSql + String.Format(sPlayerRecentItemInsertQueryFormat, pPlayerId, itemId);
            }            
        }
        
        public static void Save(Update pUpdate, SqlConnection pConn)
        {

            if (pUpdate.Players.Count == 0)
            {
                return;
            }

            DataRow dr = null;
            DataTable dtUpdate = sPlayerUpdateSchema.Clone();
            DataTable dtInsert = sPlayerInsertSchema.Clone();
            DataTable dtEquipmentInsert = sPlayerEquipmentSchema.Clone();
            DataTable dtInfluenceInsert = sPlayerInfluenceSchema.Clone();
            DataTable dtTitleInsert = sPlayerTitleSchema.Clone();
            DataTable dtAchievementInsert = sPlayerAchievementSchema.Clone();

            dtUpdate.BeginLoadData();
            dtInfluenceInsert.BeginLoadData();
            dtEquipmentInsert.BeginLoadData();
            dtInfluenceInsert.BeginLoadData();
            dtTitleInsert.BeginLoadData();
            dtAchievementInsert.BeginLoadData();
            
            String locale = pUpdate.Language.ToString();
            
                SqlCommand cmd = pConn.CreateCommand();

             
                bool isNewRow = false;
                Int32 playerId = 0;
                Int32 serverId = DBServers.GetServerId(pUpdate.ServerName);
                String deleteIds = "";
                String sql = "";
                Int32 guildId = 0;
                
                foreach (Player player in pUpdate.Players)
                {                    
                    playerId = GetPlayerId(player.Name.Value, serverId);
                    
                    isNewRow = playerId <= 0;
                    if (isNewRow)
                    {
                        dr = dtInsert.NewRow();
                    }
                    else
                    {
                        dr = dtUpdate.NewRow();
                        dr["id"] = playerId;
                    }

                    dr["name"] = player.Name.Value;
                    if (player.Name.Flag.Contains("F"))
                    {
                        dr["gender"] = 2;
                    }
                    else
                    {
                        dr["gender"] = 1;
                    }
                    dr["server_id"] = serverId;
                    dr["owner_id"] = pUpdate.UserId;
                    if (pUpdate.Guilds.Count > 0)
                    {
                        guildId = DBGuilds.GetGuildId(pUpdate.Guilds[0].Name.Value, serverId);
                        dr["guild_id"] = guildId;
                    }
                    else
                    {
                        dr["guild_id"] = 0;
                    }
                    dr["xp_rest"] = player.XpRest;
                    dr["xp_needed"] = player.XpNeeded;
                    dr["xp_earned"] = player.XpEarned;

                    dr["armor"] = player.Armor;
                    dr["level"] = player.Level;
                    dr["race_id"] = player.Race;
                    dr["career_id"] = player.Career;
                    dr["hit_points"] = player.HitPoints;
                    dr["action_points"] = player.ActionPoints;
                    dr["dps"] = player.DPS;
                    dr["lifetime_kills"] = player.LifetimeKills;
                    dr["lifetime_deaths"] = player.LifetimeDeaths;
                    dr["lifetime_deathblows"] = player.LifetimeDeathBlows;

                    dr["renown_rank"] = player.RenownRank;
                    dr["renown_title"] = player.RenownTitle;
                    dr["renown_earned"] = player.RenownEarned;
                    dr["renown_needed"] = player.RenownNeeded;


                   
                    for (Int32 index = 0; index < NUM_TRADESKILLS; ++index)
                    {
                        if (index < player.Tradeskills.Count)
                        {
                            dr["tradeskill_id" + index] = player.Tradeskills[index].Id;
                            dr["tradeskill_level" + index] = player.Tradeskills[index].SkillLevel;
                        }
                        else
                        {
                            dr["tradeskill_id" + index] = 0;
                            dr["tradeskill_level" + index] = 0;
                        }
                    }

                    for (Int32 index = 1; index <= NUM_STATS; ++index)
                    {
                        dr["stat_base" + index] = 0;
                        dr["stat_modified" + index] = 0;
                    }

                    foreach (PlayerStat stat in player.Stats)
                    {
                        if (stat.Id > NUM_STATS)
                        {
                            continue;
                        }
                        dr["stat_base" + stat.Id] = stat.BaseValue;
                        dr["stat_modified" + stat.Id] = stat.ModifiedValue;
                    }

                    // Meta Data
                    
                    dr["posted"] = DateTime.UtcNow;
                    dr["updated"] = DateTime.UtcNow;

                    if (isNewRow)
                    {
                        cmd.CommandText = DB.GetFilledInsertSQL(sInsertQuery, sPlayerInsertSchema, dr, sIgnoreInsertColumns, locale);
                        playerId = (Int32)cmd.ExecuteScalar();
                        AddPlayer(player.Name.Value, serverId, playerId);
                        if (guildId > 0)
                        {
                            sql += "update guild_roster_entry set player_id = " + playerId + " where player_name = '" + player.Name.Value.Replace("'", "''") + "' and guild_id = " + guildId + ";";
                        }
                    }
                    else
                    {
                        dtUpdate.Rows.Add(dr);
                    }

                    deleteIds += "," + playerId;

                    foreach (PlayerEquipment equipment in player.Equipment)
                    {
                        DataRow equipmentRow = dtEquipmentInsert.NewRow();
                        equipmentRow["player_id"] = playerId;
                        equipmentRow["slot_id"] = equipment.Slot;
                        equipmentRow["item_id"] = equipment.ItemId;
                        for (Byte i = 1; i <= 3;i++ )
                        {
                            equipmentRow["enhancement" + i] = 0;
                        }
                        foreach (PlayerItemEnhancement enhancement in equipment.Enhancements)
                        {
                            if (enhancement.ItemId == 0)
                            {
                                enhancement.ItemId = DBItems.GetItemId(enhancement.ItemName, locale);
                            }
                            if (enhancement.ItemId > 0)
                            {
                                equipmentRow["enhancement" + enhancement.Index] = enhancement.ItemId;
                            }
                            
                        }


                        dtEquipmentInsert.Rows.Add(equipmentRow);
                        
                    }

                    foreach (PlayerInfluence influence in player.Influence)
                    {

                        if (influence.Amount > 0)
                        {
                            DataRow influenceRow = dtInfluenceInsert.NewRow();
                            influenceRow["player_id"] = playerId;
                            influenceRow["influence_id"] = influence.Id;
                            influenceRow["amount"] = influence.Amount;
                            dtInfluenceInsert.Rows.Add(influenceRow);
                        }

                    }

                    foreach (Int32 title in player.Titles) 
                    {
                       
                        DataRow titleRow =  dtTitleInsert.NewRow();
                        titleRow["player_id"] = playerId;
                        titleRow["title_id"] = title;
                        dtTitleInsert.Rows.Add(titleRow);                                                
                    }

                    foreach (Int32 achievement in player.Achievements)
                    {

                        DataRow achievementRow =  dtAchievementInsert.NewRow();
                        achievementRow["player_id"] = playerId;
                        achievementRow["achievement_id"] = achievement;
                        dtAchievementInsert.Rows.Add(achievementRow);
                    }                    

                    SetLootHistorySql(ref sql, pUpdate.LootHistory, playerId);                 

                }

                if (deleteIds.Length > 0)
                {
                    sql += "delete from player_equipment where player_id in(" + deleteIds.Substring(1) + ");delete from player_influence where player_id in(" + deleteIds.Substring(1) + ");delete from player_title where player_id in(" + deleteIds.Substring(1) + ");delete from player_achievement where player_id in(" + deleteIds.Substring(1) + ");";
                }
                

                cmd.CommandText = sql; 
                cmd.ExecuteNonQuery();

                if (dtEquipmentInsert.Rows.Count > 0)
                {
                    using (SqlBulkCopy bulk = new SqlBulkCopy(pConn,
                                       SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                       null))
                    {
                        bulk.DestinationTableName = "player_equipment";
                        bulk.BatchSize = 5000;
                        bulk.WriteToServer(dtEquipmentInsert);
                        bulk.Close();
                    }
                }

                if (dtInfluenceInsert.Rows.Count > 0)
                {
                    using (SqlBulkCopy bulk = new SqlBulkCopy(pConn,
                                        SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                        null))
                    {
                        bulk.DestinationTableName = "player_influence";
                        bulk.BatchSize = 5000;
                        bulk.WriteToServer(dtInfluenceInsert);
                        bulk.Close();
                    }
                }

                if (dtTitleInsert.Rows.Count > 0)
                {
                    using (SqlBulkCopy bulk = new SqlBulkCopy(pConn,
                                         SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                         null))
                    {
                        bulk.DestinationTableName = "player_title";
                        bulk.BatchSize = 5000;
                        bulk.WriteToServer(dtTitleInsert);
                        bulk.Close();
                    }
                }

                if (dtAchievementInsert.Rows.Count > 0)
                {
                    using (SqlBulkCopy bulk = new SqlBulkCopy(pConn,
                                         SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                         null))
                    {
                        bulk.DestinationTableName = "player_achievement";
                        bulk.BatchSize = 5000;
                        bulk.WriteToServer(dtAchievementInsert);
                        bulk.Close();
                    }
                }

                if (dtUpdate.Rows.Count > 0)
                {
                    cmd.CommandText = sTempTableCreation;
                    cmd.ExecuteNonQuery();
                    using (SqlBulkCopy bulk = new SqlBulkCopy(pConn,
                                                      SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                      null))
                    {
                        bulk.BatchSize = 5000;
                        bulk.DestinationTableName = "#player";
                        bulk.WriteToServer(dtUpdate);
                        bulk.Close();
                    }
                    
                    cmd.CommandText = sUpdateQuery;
                    cmd.ExecuteNonQuery();
                    cmd.CommandText = "DROP TABLE #player;";
                    cmd.ExecuteNonQuery();
                }            
        }

    }
}


