﻿using Curse;
using Curse.WAR;
using System;
using System.Data.SqlClient;
using System.Collections.Generic;
using System.Data;
using System.Linq;
namespace WARDataService
{
    public static partial class DBServers
    {

        private static Dictionary<CustomKey, Int32> sServerNameToId = new Dictionary<CustomKey, Int32>(new CustomKey.CustomKeyComparer());
        private static Dictionary<String, Byte> sServerLocales = new Dictionary<String, Byte>();

        public static void Initialize()
        {
            DB.PopulateNameToID(sServerNameToId, "server", "");

            using (SqlConnection conn = new SqlConnection(Config.Instance.ConnectionString))
            {
                conn.Open();
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "select name, locale from server";
                using (SqlDataReader reader = cmd.ExecuteReader())
                {
                    while (reader.Read())
                    {
                        sServerLocales.Add(reader.GetString(0), reader.GetByte(1));
                    }
                }
            }
        }

        public static bool IsSupportedServer(String pServerName, String[] pSupportedLocales)
        {
            if (!sServerLocales.ContainsKey(pServerName))
            {
                return false;
            }            
            ELocale locale = (ELocale)sServerLocales[pServerName];
            if (locale == 0)
            {
                return false;
            }
            if (Array.IndexOf(pSupportedLocales, locale.ToString()) >= 0)
            {
                return true;
            }
            else
            {
                return false;
            }
        }

        public static Int32 GetServerId(String pServerName)
        {
            CustomKey key = new CustomKey(pServerName);
            Int32 id = 0;
            sServerNameToId.TryGetValue(key, out id);
            return id;
        }

        public static void AddServer(String pServerName, Int32 pServerId)
        {
            DB.AddNameFromId(sServerNameToId, "", pServerName, pServerId);
            sServerLocales.Add(pServerName, 0);
        }


        public static void Save(Update pUpdate, SqlConnection pConn)
        {

            CustomKey key = new CustomKey(pUpdate.ServerName);
            if (GetServerId(pUpdate.ServerName) > 0)
            {
                return;
            }

            SqlCommand cmd = pConn.CreateCommand();
            cmd.CommandText = "insert into server(name) output inserted.id values(N'" + pUpdate.ServerName.Replace("'", "''") + "')";
            Int32 serverId = (Int32)cmd.ExecuteScalar();
            AddServer(pUpdate.ServerName, serverId);                
           
        }

    }
}
