﻿using Curse;
using System;
using System.Collections.Generic;
using System.IO;

namespace WoWDataCenter.DBC
{
    public static class AreaTableDBC
    {
        private static Dictionary<CustomKey, UInt16> sAreas =
            new Dictionary<CustomKey, UInt16>(new CustomKey.CustomKeyComparer());

        public static Boolean Load()
        {
            CPUMonitor monitorTotal = new CPUMonitor("AreaTableDBC Loading");

            sAreas.Clear();
            if (!Array.TrueForAll<Config.AreaTableDBCSchema>(Config.Instance.AreaTableDBCSchemas,
                                                             s => Load(s)))
            {
                return false;
            }

            Logger.Log(ELogLevel.Debug,
                       null,
                       monitorTotal.ToString());
            return true;
        }
        private static Boolean Load(Config.AreaTableDBCSchema pSchema)
        {
            foreach (ELocale locale in pSchema.Locales)
            {
                String dbcPath = String.Format("{0}{1}{2}{3}{4}AreaTable.dbc",
                                               Config.Instance.DBCPath,
                                               pSchema.Version,
                                               Path.DirectorySeparatorChar,
                                               locale,
                                               Path.DirectorySeparatorChar);

                DBCReader dbcReader = DBCReader.Open(dbcPath);
                if (dbcReader == null)
                {
                    Logger.Log(ELogLevel.Error,
                               "Unable to open {0}",
                               dbcPath);
                    return false;
                }

                Int32 areaId;
                Int32 areaNameOffset;
                String areaName;
                CustomKey key;
                while (dbcReader.NextRow())
                {
                    if (dbcReader.ReadField(pSchema.Id, out areaId) &&
                        dbcReader.ReadField(pSchema.Name, out areaNameOffset) &&
                        dbcReader.ReadString(areaNameOffset, out areaName) &&
                        areaName.Length > 0)
                    {
                        key = new CustomKey(pSchema.Version,
                                            locale,
                                            areaName);

                        sAreas[key] = Convert.ToUInt16(areaId);
                    }
                }
                dbcReader.Close();
            }
            return true;
        }

        public static Boolean LookupId(UInt16 pVersion,
                                       ELocale pLocale,
                                       String pName,
                                       out UInt16 pId)
        {
            return sAreas.TryGetValue(new CustomKey(pVersion,
                                                       pLocale,
                                                       pName),
                                      out pId);
        }
    }
}
