﻿using Curse;
using System;
using System.Collections.Generic;
using System.IO;

namespace WoWDataCenter.DBC
{
    public static class ChrClassesDBC
    {
        public static Byte MaxClass = 0;
        private static HashSet<CustomKey> sClasses =
            new HashSet<CustomKey>(new CustomKey.CustomKeyComparer());

        public static Boolean Load()
        {
            CPUMonitor monitorTotal = new CPUMonitor("ChrClassesDBC Loading");

            sClasses.Clear();
            if (!Array.TrueForAll<Config.ChrClassesDBCSchema>(Config.Instance.ChrClassesDBCSchemas,
                                                            s => Load(s)))
            {
                return false;
            }

            Logger.Log(ELogLevel.Debug,
                       null,
                       monitorTotal.ToString());
            return true;
        }
        private static Boolean Load(Config.ChrClassesDBCSchema pSchema)
        {
            foreach (ELocale locale in pSchema.Locales)
            {

                String dbcPath = String.Format("{0}{1}{2}{3}{4}ChrClasses.dbc",
                                               Config.Instance.DBCPath,
                                               pSchema.Version,
                                               Path.DirectorySeparatorChar,
                                               locale,
                                               Path.DirectorySeparatorChar);

                DBCReader dbcReader = DBCReader.Open(dbcPath);
                if (dbcReader == null)
                {
                    Logger.Log(ELogLevel.Error,
                               "Unable to open {0}",
                               dbcPath);
                    return false;
                }

                Int32 classId;
                CustomKey key;
                while (dbcReader.NextRow())
                {
                    if (dbcReader.ReadField(pSchema.Id, out classId))
                    {
                        key = new CustomKey(pSchema.Version,
                                            locale,
                                            classId);
                        MaxClass = Math.Max(MaxClass, Convert.ToByte(classId));
                        sClasses.Add(key);
                    }
                }
                dbcReader.Close();
            }
            return true;
        }

        public static Boolean Exists(UInt16 pVersion,
                                     ELocale pLocale,
                                     Byte pId)
        {
            return sClasses.Contains(new CustomKey(pVersion,
                                                   pLocale,
                                                   pId));
        }
    }
}
