﻿using Curse;
using System;
using System.Collections.Generic;
using System.IO;

namespace WoWDataCenter.DBC
{
    public static class ChrRacesDBC
    {
        public static Byte MaxRace = 0;
        private static HashSet<CustomKey> sRaces =
            new HashSet<CustomKey>(new CustomKey.CustomKeyComparer());

        public static Boolean Load()
        {
            CPUMonitor monitorTotal = new CPUMonitor("ChrRacesDBC Loading");

            sRaces.Clear();
            if (!Array.TrueForAll<Config.ChrRacesDBCSchema>(Config.Instance.ChrRacesDBCSchemas,
                                                            s => Load(s)))
            {
                return false;
            }

            Logger.Log(ELogLevel.Debug,
                       null,
                       monitorTotal.ToString());
            return true;
        }
        private static Boolean Load(Config.ChrRacesDBCSchema pSchema)
        {
            foreach (ELocale locale in pSchema.Locales)
            {

                String dbcPath = String.Format("{0}{1}{2}{3}{4}ChrRaces.dbc",
                                               Config.Instance.DBCPath,
                                               pSchema.Version,
                                               Path.DirectorySeparatorChar,
                                               locale,
                                               Path.DirectorySeparatorChar);

                DBCReader dbcReader = DBCReader.Open(dbcPath);
                if (dbcReader == null)
                {
                    Logger.Log(ELogLevel.Error,
                               "Unable to open {0}",
                               dbcPath);
                    return false;
                }

                Int32 raceId;
                CustomKey key;
                while (dbcReader.NextRow())
                {
                    if (dbcReader.ReadField(pSchema.Id, out raceId))
                    {
                        key = new CustomKey(pSchema.Version,
                                            locale,
                                            raceId);
                        MaxRace = Math.Max(MaxRace, Convert.ToByte(raceId));
                        sRaces.Add(key);
                    }
                }
                dbcReader.Close();
            }
            return true;
        }

        public static Boolean Exists(UInt16 pVersion,
                                     ELocale pLocale,
                                     Byte pId)
        {
            return sRaces.Contains(new CustomKey(pVersion,
                                                 pLocale,
                                                 pId));
        }
    }
}
