﻿using Curse;
using System;
using System.Collections.Generic;
using System.IO;

namespace WoWDataCenter.DBC
{
    public static class FactionDBC
    {
        private static Dictionary<CustomKey, UInt16> sFactions =
            new Dictionary<CustomKey, UInt16>(new CustomKey.CustomKeyComparer());

        public static Boolean Load()
        {
            CPUMonitor monitorTotal = new CPUMonitor("FactionDBC Loading");

            sFactions.Clear();
            if (!Array.TrueForAll<Config.FactionDBCSchema>(Config.Instance.FactionDBCSchemas,
                                                           s => Load(s)))
            {
                return false;
            }

            Logger.Log(ELogLevel.Debug,
                       null,
                       monitorTotal.ToString());
            return true;
        }
        private static Boolean Load(Config.FactionDBCSchema pSchema)
        {
            foreach (ELocale locale in pSchema.Locales)
            {

                String dbcPath = String.Format("{0}{1}{2}{3}{4}Faction.dbc",
                                               Config.Instance.DBCPath,
                                               pSchema.Version,
                                               Path.DirectorySeparatorChar,
                                               locale,
                                               Path.DirectorySeparatorChar);

                DBCReader dbcReader = DBCReader.Open(dbcPath);
                if (dbcReader == null)
                {
                    Logger.Log(ELogLevel.Error,
                               "Unable to open {0}",
                               dbcPath);
                    return false;
                }

                Int32 factionId;
                Int32 factionNameOffset;
                String factionName;
                CustomKey key;
                while (dbcReader.NextRow())
                {
                    if (dbcReader.ReadField(pSchema.Id, out factionId) &&
                        dbcReader.ReadField(pSchema.Name, out factionNameOffset) &&
                        dbcReader.ReadString(factionNameOffset, out factionName) &&
                        factionName.Length > 0)
                    {
                        key = new CustomKey(pSchema.Version,
                                            locale,
                                            factionName);

                        sFactions[key] = Convert.ToUInt16(factionId);
                    }
                }
                dbcReader.Close();
            }
            return true;
        }

        public static Boolean LookupId(UInt16 pVersion,
                                       ELocale pLocale,
                                       String pName,
                                       out UInt16 pId)
        {
            return sFactions.TryGetValue(new CustomKey(pVersion,
                                                       pLocale,
                                                       pName),
                                         out pId);
        }
    }
}
