﻿using Curse;
using System;
using System.Collections.Generic;
using System.IO;

namespace WoWDataCenter.DBC
{
    public static class ItemDBC
    {
        private static HashSet<CustomKey> sItems =
            new HashSet<CustomKey>(new CustomKey.CustomKeyComparer());

        public static Boolean Load()
        {
            CPUMonitor monitorTotal = new CPUMonitor("ItemDBC Loading");

            sItems.Clear();
            if (!Array.TrueForAll<Config.ItemDBCSchema>(Config.Instance.ItemDBCSchemas,
                                                        i => Load(i)))
            {
                return false;
            }

            Logger.Log(ELogLevel.Debug,
                       null,
                       monitorTotal.ToString());
            return true;
        }
        private static Boolean Load(Config.ItemDBCSchema pSchema)
        {
            foreach (ELocale locale in pSchema.Locales)
            {

                String dbcPath = String.Format("{0}{1}{2}{3}{4}Item.dbc",
                                               Config.Instance.DBCPath,
                                               pSchema.Version,
                                               Path.DirectorySeparatorChar,
                                               locale,
                                               Path.DirectorySeparatorChar);

                DBCReader dbcReader = DBCReader.Open(dbcPath);
                if (dbcReader == null)
                {
                    Logger.Log(ELogLevel.Error,
                               "Unable to open {0}",
                               dbcPath);
                    return false;
                }

                Int32 itemId;
                Int32 itemSlotId;
                CustomKey key;
                while (dbcReader.NextRow())
                {
                    if (dbcReader.ReadField(pSchema.Id, out itemId) &&
                        dbcReader.ReadField(pSchema.SlotId, out itemSlotId))
                    {
                        key = new CustomKey(pSchema.Version,
                                            locale,
                                            itemId,
                                            itemSlotId);
                        sItems.Add(key);

                        if (itemSlotId == 13)
                        {
                            sItems.Add(new CustomKey(pSchema.Version,
                                                     locale,
                                                     itemId,
                                                     21));
                            sItems.Add(new CustomKey(pSchema.Version,
                                                     locale,
                                                     itemId,
                                                     22));
                            sItems.Add(new CustomKey(pSchema.Version,
                                                     locale,
                                                     itemId,
                                                     23));
                        }
                    }
                }
                dbcReader.Close();
            }
            return true;
        }

        public static Boolean Exists(UInt16 pVersion,
                                     ELocale pLocale,
                                     Int32 pId,
                                     Int32 pSlotId)
        {
            return sItems.Contains(new CustomKey(pVersion,
                                                 pLocale,
                                                 pId,
                                                 pSlotId));
        }
    }
}
