﻿using Curse;
using System;
using System.Collections.Generic;
using System.IO;

namespace WoWDataCenter.DBC
{
    public static class SkillLineAbilityDBC
    {
        private static Dictionary<CustomKey, UInt16> sSpellIdToLineId =
            new Dictionary<CustomKey, UInt16>(new CustomKey.CustomKeyComparer());

        public static Boolean Load()
        {
            CPUMonitor monitorTotal = new CPUMonitor("SkillLineAbilityDBC Loading");

            sSpellIdToLineId.Clear();
            if (!Array.TrueForAll<Config.SkillLineAbilityDBCSchema>(Config.Instance.SkillLineAbilityDBCSchemas,
                                                                    s => Load(s)))
            {
                return false;
            }

            Logger.Log(ELogLevel.Debug,
                       null,
                       monitorTotal.ToString());
            return true;
        }
        private static Boolean Load(Config.SkillLineAbilityDBCSchema pSchema)
        {
            foreach (ELocale locale in pSchema.Locales)
            {

                String dbcPath = String.Format("{0}{1}{2}{3}{4}SkillLineAbility.dbc",
                                               Config.Instance.DBCPath,
                                               pSchema.Version,
                                               Path.DirectorySeparatorChar,
                                               locale,
                                               Path.DirectorySeparatorChar);

                DBCReader dbcReader = DBCReader.Open(dbcPath);
                if (dbcReader == null)
                {
                    Logger.Log(ELogLevel.Error,
                               "Unable to open {0}",
                               dbcPath);
                    return false;
                }

                Int32 skillLineId;
                Int32 spellId;
                CustomKey key;
                while (dbcReader.NextRow())
                {
                    if (dbcReader.ReadField(pSchema.SkillLineId, out skillLineId) &&
                        dbcReader.ReadField(pSchema.SpellId, out spellId))
                    {
                        key = new CustomKey(pSchema.Version,
                                            locale,
                                            spellId);
                        sSpellIdToLineId[key] = Convert.ToUInt16(skillLineId);
                    }
                }
                dbcReader.Close();
            }
            return true;
        }

        public static Boolean LookupId(UInt16 pVersion,
                                       ELocale pLocale,
                                       Int32 pSpellId,
                                       out UInt16 pLineId)
        {
            return sSpellIdToLineId.TryGetValue(new CustomKey(pVersion,
                                                              pLocale,
                                                              pSpellId),
                                                out pLineId);
        }
    }
}