﻿using Curse;
using Curse.WoW;
using Curse.WoW.WDB;
using WoWDataCenter.DBC;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Text;

namespace WoWDataCenter
{
    public static partial class DB
    {
        public static void LoadCreatureSchemaOrdinals()
        {
            sCreatureOrdinalId = sCreatureSchema.Columns.IndexOf("id");
            sCreatureOrdinalVersionId = sCreatureSchema.Columns.IndexOf("version_id");
            sCreatureOrdinalType = sCreatureSchema.Columns.IndexOf("creature_type");
            sCreatureOrdinalFamily = sCreatureSchema.Columns.IndexOf("family");
            sCreatureOrdinalFlag = sCreatureSchema.Columns.IndexOf("flag");
            sCreatureOrdinalSpellData = sCreatureSchema.Columns.IndexOf("spell_data");
            sCreatureOrdinalDisplay1 = sCreatureSchema.Columns.IndexOf("display1");
            sCreatureOrdinalDisplay2 = sCreatureSchema.Columns.IndexOf("display2");
            sCreatureOrdinalDisplay3 = sCreatureSchema.Columns.IndexOf("display3");
            sCreatureOrdinalDisplay4 = sCreatureSchema.Columns.IndexOf("display4");
            sCreatureOrdinalFaction = sCreatureSchema.Columns.IndexOf("faction");
            sCreatureOrdinalMinLevel = sCreatureSchema.Columns.IndexOf("min_level");
            sCreatureOrdinalMaxLevel = sCreatureSchema.Columns.IndexOf("max_level");
            sCreatureOrdinalLevelSum = sCreatureSchema.Columns.IndexOf("level_sum");
            sCreatureOrdinalLevelCount = sCreatureSchema.Columns.IndexOf("level_count");
            sCreatureOrdinalMinHealth = sCreatureSchema.Columns.IndexOf("min_health");
            sCreatureOrdinalMaxHealth = sCreatureSchema.Columns.IndexOf("max_health");
            sCreatureOrdinalHealthSum = sCreatureSchema.Columns.IndexOf("health_sum");
            sCreatureOrdinalHealthCount = sCreatureSchema.Columns.IndexOf("health_count");
            sCreatureOrdinalObservationCount = sCreatureSchema.Columns.IndexOf("observation_count");
            sCreatureOrdinalPostedId = sCreatureSchema.Columns.IndexOf("posted_id");
            sCreatureOrdinalUpdatedId = sCreatureSchema.Columns.IndexOf("updated_id");
            sCreatureOrdinalPosted = sCreatureSchema.Columns.IndexOf("posted");
            sCreatureOrdinalUpdated = sCreatureSchema.Columns.IndexOf("updated");
        }

        /**
         * Publically exposed method for updating cached creatures
         * 
         * @param  pUserId     the id of the user sending the update
         * @param  pHost       the host of the user updating in IP format
         * @param  pVersion    the wow version
         * @param  pLocale     the locale
         * @param  pCreatures  the list of creatures contained in the update
         */
        public static void UpdateCachedCreatures(Int32 pUserId,
                                                 String pHost,
                                                 UInt16 pVersion,
                                                 ELocale pLocale,
                                                 PackableList<WMOBCreature> pCreatures)
        {
#if ALPHA
            CPUMonitor monitorTotal = new CPUMonitor("UpdateCachedCreatures for {0} entries", pCreatures.Count);
#endif

            if (pCreatures.Count == 0)
            {
                return;
            }

            DataRow dr = null;
            DataTable dtInsert = sCreatureSchema.Clone();
            DataTable dtUpdate = sCreatureSchema.Clone();

            dtInsert.BeginLoadData();
            dtUpdate.BeginLoadData();

            CustomKey key;
            String locale = pLocale.ToString();
            using (SqlConnection conn = new SqlConnection(Config.Instance.WoWDB))
            {
                conn.Open();
                SqlBulkCopy bulkInsert = new SqlBulkCopy(conn,
                                                         SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                         null);
                SqlBulkCopy bulkUpdate = new SqlBulkCopy(conn,
                                                         SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                         null);
                bulkInsert.BatchSize = 5000;
                bulkUpdate.BatchSize = 5000;
                bulkInsert.DestinationTableName = "creature";
                bulkUpdate.DestinationTableName = "#creature";

                foreach (WMOBCreature creature in pCreatures)
                {
                    if (!ReadyForDB(sCreatureHistory,
                                    sCreatureConfirmations,
                                    creature.Id,
                                    Config.Instance.CreatureExpiration,
                                    Config.Instance.MinConfirmations,
                                    pUserId,
                                    pVersion,
                                    pLocale))
                    {
                        continue;
                    }

                    key = new CustomKey(pVersion,
                                        creature.Id);

                    if (sCreatureHash.Contains(key))
                    {
                        dr = dtUpdate.NewRow();
                    }
                    else
                    {
                        dr = dtInsert.NewRow();
                    }

                    dr[sCreatureOrdinalId] = creature.Id;
                    dr[sCreatureOrdinalVersionId] = pVersion;
                    dr["name_" + locale] = creature.Name;
                    dr["description_" + locale] = creature.Description;
                    dr[sCreatureOrdinalType] = creature.Type;
                    dr[sCreatureOrdinalFamily] = creature.Family;
                    dr[sCreatureOrdinalFlag] = creature.Flag;
                    dr[sCreatureOrdinalSpellData] = creature.SpellData;
                    dr[sCreatureOrdinalDisplay1] = creature.Display1Info;
                    dr[sCreatureOrdinalDisplay2] = creature.Display2Info;
                    dr[sCreatureOrdinalDisplay3] = creature.Display3Info;
                    dr[sCreatureOrdinalDisplay4] = creature.Display4Info;
                    dr[sCreatureOrdinalFaction] = 0;
                    dr[sCreatureOrdinalLevelSum] = 0;
                    dr[sCreatureOrdinalLevelCount] = 0;
                    dr[sCreatureOrdinalHealthSum] = 0;
                    dr[sCreatureOrdinalHealthCount] = 0;
                    dr[sCreatureOrdinalObservationCount] = 0;
                    dr[sCreatureOrdinalPostedId] = pUserId;
                    dr[sCreatureOrdinalUpdatedId] = pUserId;
                    dr[sCreatureOrdinalPosted] = DateTime.UtcNow;
                    dr[sCreatureOrdinalUpdated] = DateTime.UtcNow;

                    if (sCreatureHash.Contains(key))
                    {
                        dtUpdate.Rows.Add(dr);
                    }
                    else
                    {
                        lock (sCreatureHash)
                        {
                            sCreatureHash.Add(key);
                        }
                        dtInsert.Rows.Add(dr);
                    }
                }

                if (dtInsert.Rows.Count > 0)
                {
#if ALPHA
                    CPUMonitor monitorBulk = new CPUMonitor("UpdateCachedCreatures Bulk Insert Copy");
#endif
                    bulkInsert.WriteToServer(dtInsert);
#if ALPHA
                    Logger.Log(ELogLevel.Debug,
                               pHost,
                               monitorBulk.ToString());
#endif
                }

                if (dtUpdate.Rows.Count > 0)
                {
                    SqlCommand cmd = conn.CreateCommand();
                    cmd.CommandText = "SELECT TOP 0 * INTO #creature FROM creature;";
                    cmd.ExecuteNonQuery();
                    cmd.CommandText = "CREATE CLUSTERED INDEX PK_creature ON #creature(id,version_id);";
                    cmd.ExecuteNonQuery();
#if ALPHA
                    CPUMonitor monitorBulk = new CPUMonitor("UpdateCachedCreatures Bulk Update Copy");
#endif
                    bulkUpdate.WriteToServer(dtUpdate);
#if ALPHA
                    Logger.Log(ELogLevel.Debug,
                               pHost,
                               monitorBulk.ToString());

                    CPUMonitor monitorTemp = new CPUMonitor("UpdateCachedCreatures Update From Temp");
#endif
                    cmd.CommandText = String.Format(sCachedCreatureUpdateQueryFormat,
                                                    locale);
                    cmd.ExecuteNonQuery();
#if ALPHA
                    Logger.Log(ELogLevel.Debug,
                               pHost,
                               monitorTemp.ToString());
#endif

                    cmd.CommandText = "DROP TABLE #creature;";
                    cmd.ExecuteNonQuery();
                }
            }
#if ALPHA
            Logger.Log(ELogLevel.Debug,
                       pHost,
                       monitorTotal.ToString());
#endif
        }


        private static Int32 sCreatureOrdinalId = 0;
        private static Int32 sCreatureOrdinalVersionId = 0;
        private static Int32 sCreatureOrdinalType = 0;
        private static Int32 sCreatureOrdinalFamily = 0;
        private static Int32 sCreatureOrdinalFlag = 0;
        private static Int32 sCreatureOrdinalSpellData = 0;
        private static Int32 sCreatureOrdinalDisplay1 = 0;
        private static Int32 sCreatureOrdinalDisplay2 = 0;
        private static Int32 sCreatureOrdinalDisplay3 = 0;
        private static Int32 sCreatureOrdinalDisplay4 = 0;
        private static Int32 sCreatureOrdinalFaction = 0;
        private static Int32 sCreatureOrdinalMinLevel = 0;
        private static Int32 sCreatureOrdinalMaxLevel = 0;
        private static Int32 sCreatureOrdinalLevelSum = 0;
        private static Int32 sCreatureOrdinalLevelCount = 0;
        private static Int32 sCreatureOrdinalMinHealth = 0;
        private static Int32 sCreatureOrdinalMaxHealth = 0;
        private static Int32 sCreatureOrdinalHealthSum = 0;
        private static Int32 sCreatureOrdinalHealthCount = 0;
        private static Int32 sCreatureOrdinalObservationCount = 0;
        private static Int32 sCreatureOrdinalPostedId = 0;
        private static Int32 sCreatureOrdinalUpdatedId = 0;
        private static Int32 sCreatureOrdinalPosted = 0;
        private static Int32 sCreatureOrdinalUpdated = 0;
    }
}
