﻿using System;

namespace WoWDataCenter
{
    /**
     * Partial class DB containing pre-baked SQL statements
     *
     * @author Shane Bryldt
     */
    public static partial class DB
    {
        private static String sCachedCreatureUpdateQueryFormat =
            "UPDATE creature SET " +
            "name_{0}=tmp.name_{0}," +
            "description_{0}=tmp.description_{0}," +
            "creature_type=tmp.creature_type," +
            "family=tmp.family," +
            "flag=tmp.flag," +
            "spell_data=tmp.spell_data," +
            "display1=tmp.display1," +
            "display2=tmp.display2," +
            "display3=tmp.display3," +
            "display4=tmp.display4," +
            "updated_id=tmp.updated_id," +
            "updated=tmp.updated" +
            " FROM creature,#creature tmp" +
            " WHERE creature.id=tmp.id AND creature.version_id=tmp.version_id;";

        private static String sCachedGameObjectUpdateQueryFormat =
            "UPDATE gameobject SET " +
            "name_{0}=tmp.name_{0}," +
            "type=tmp.type," +
            "display_info=tmp.display_info," +
            "lock_id=tmp.lock_id," +
            "updated_id=tmp.updated_id," +
            "updated=tmp.updated" +
            " FROM gameobject,#gameobject tmp" +
            " WHERE gameobject.id=tmp.id AND gameobject.version_id=tmp.version_id;";

        private static String sCachedItemUpdateQueryFormat =
            "UPDATE item SET " +
            "name_{0}=tmp.name_{0}," +
            "description_{0}=tmp.description_{0}," +
            "item_class=tmp.item_class," +
            "item_sub_class=tmp.item_sub_class," +
            "display=tmp.display," +
            "quality=tmp.quality," +
            "item_type=tmp.item_type," +
            "buy_price=tmp.buy_price," +
            "sell_price=tmp.sell_price," +
            "slot=tmp.slot," +
            "required_class=tmp.required_class," +
            "required_race=tmp.required_race," +
            "level=tmp.level," +
            "required_level=tmp.required_level," +
            "required_skill_id=tmp.required_skill_id," +
            "required_skill_level=tmp.required_skill_level," +
            "required_spell_id=tmp.required_spell_id," +
            "required_rank=tmp.required_rank," +
            "required_faction=tmp.required_faction," +
            "required_faction_level=tmp.required_faction_level," +
            "stack_unique=tmp.stack_unique," +
            "stack_normal=tmp.stack_normal," +
            "container_slots=tmp.container_slots," +
            "stat_1=tmp.stat_1," +
            "stat_1_value=tmp.stat_1_value," +
            "stat_2=tmp.stat_2," +
            "stat_2_value=tmp.stat_2_value," +
            "stat_3=tmp.stat_3," +
            "stat_3_value=tmp.stat_3_value," +
            "stat_4=tmp.stat_4," +
            "stat_4_value=tmp.stat_4_value," +
            "stat_5=tmp.stat_5," +
            "stat_5_value=tmp.stat_5_value," +
            "stat_6=tmp.stat_6," +
            "stat_6_value=tmp.stat_6_value," +
            "stat_7=tmp.stat_7," +
            "stat_7_value=tmp.stat_7_value," +
            "stat_8=tmp.stat_8," +
            "stat_8_value=tmp.stat_8_value," +
            "stat_9=tmp.stat_9," +
            "stat_9_value=tmp.stat_9_value," +
            "stat_10=tmp.stat_10," +
            "stat_10_value=tmp.stat_10_value," +
            "spell_1=tmp.spell_1," +
            "spell_1_trigger=tmp.spell_1_trigger," +
            "spell_1_charges=tmp.spell_1_charges," +
            "spell_1_cooldown=tmp.spell_1_cooldown," +
            "spell_1_category=tmp.spell_1_category," +
            "spell_1_category_cooldown=tmp.spell_1_category_cooldown," +
            "spell_2=tmp.spell_2," +
            "spell_2_trigger=tmp.spell_2_trigger," +
            "spell_2_charges=tmp.spell_2_charges," +
            "spell_2_cooldown=tmp.spell_2_cooldown," +
            "spell_2_category=tmp.spell_2_category," +
            "spell_2_category_cooldown=tmp.spell_2_category_cooldown," +
            "spell_3=tmp.spell_3," +
            "spell_3_trigger=tmp.spell_3_trigger," +
            "spell_3_charges=tmp.spell_3_charges," +
            "spell_3_cooldown=tmp.spell_3_cooldown," +
            "spell_3_category=tmp.spell_3_category," +
            "spell_3_category_cooldown=tmp.spell_3_category_cooldown," +
            "spell_4=tmp.spell_4," +
            "spell_4_trigger=tmp.spell_4_trigger," +
            "spell_4_charges=tmp.spell_4_charges," +
            "spell_4_cooldown=tmp.spell_4_cooldown," +
            "spell_4_category=tmp.spell_4_category," +
            "spell_4_category_cooldown=tmp.spell_4_category_cooldown," +
            "spell_5=tmp.spell_5," +
            "spell_5_trigger=tmp.spell_5_trigger," +
            "spell_5_charges=tmp.spell_5_charges," +
            "spell_5_cooldown=tmp.spell_5_cooldown," +
            "spell_5_category=tmp.spell_5_category," +
            "spell_5_category_cooldown=tmp.spell_5_category_cooldown," +
            "damage_1_min=tmp.damage_1_min," +
            "damage_1_max=tmp.damage_1_max," +
            "damage_1_type=tmp.damage_1_type," +
            "damage_2_min=tmp.damage_2_min," +
            "damage_2_max=tmp.damage_2_max," +
            "damage_2_type=tmp.damage_2_type," +
            "damage_3_min=tmp.damage_3_min," +
            "damage_3_max=tmp.damage_3_max," +
            "damage_3_type=tmp.damage_3_type," +
            "damage_4_min=tmp.damage_4_min," +
            "damage_4_max=tmp.damage_4_max," +
            "damage_4_type=tmp.damage_4_type," +
            "damage_5_min=tmp.damage_5_min," +
            "damage_5_max=tmp.damage_5_max," +
            "damage_5_type=tmp.damage_5_type," +
            "resist_physical=tmp.resist_physical," +
            "resist_holy=tmp.resist_holy," +
            "resist_fire=tmp.resist_fire," +
            "resist_nature=tmp.resist_nature," +
            "resist_frost=tmp.resist_frost," +
            "resist_shadow=tmp.resist_shadow," +
            "resist_arcane=tmp.resist_arcane," +
            "weapon_speed=tmp.weapon_speed," +
            "ammo_type=tmp.ammo_type," +
            "range_modifier=tmp.range_modifier," +
            "bond=tmp.bond," +
            "book_text=tmp.book_text," +
            "book_pages=tmp.book_pages," +
            "book_stationary=tmp.book_stationary," +
            "begin_quest=tmp.begin_quest," +
            "required_lockpick_level=tmp.required_lockpick_level," +
            "material=tmp.material," +
            "sheath=tmp.sheath," +
            "random_1_property=tmp.random_1_property," +
            "random_2_property=tmp.random_2_property," +
            "block=tmp.block," +
            "itemset=tmp.itemset," +
            "durability=tmp.durability," +
            "area=tmp.area," +
            "area_map=tmp.area_map," +
            "bag_family_id=tmp.bag_family_id," +
            "totem_category=tmp.totem_category," +
            "socket_1_color=tmp.socket_1_color," +
            "socket_2_color=tmp.socket_2_color," +
            "socket_3_color=tmp.socket_3_color," +
            "spell_item_enchantment=tmp.spell_item_enchantment," +
            "gem_properties=tmp.gem_properties," +
            "item_extended_cost=tmp.item_extended_cost," +
            "item_condextended_cost=tmp.item_condextended_cost," +
            "disenchant_skill_level=tmp.disenchant_skill_level," +
            "armor_damage_modifier=tmp.armor_damage_modifier," +
            "updated_id=tmp.updated_id," +
            "updated=tmp.updated," +
            "stat_distribution_id=tmp.stat_distribution_id," +
            "scaling_stat_mask=tmp.scaling_stat_mask" +
            " FROM item,#item tmp" +
            " WHERE item.id=tmp.id AND item.version_id=tmp.version_id;";

        private static String sCachedPageTextUpdateQueryFormat =
            "UPDATE pagetext SET " +
            "text_{0}=tmp.text_{0}," +
            "next_page_id=tmp.next_page_id," +
            "updated_id=tmp.updated_id," +
            "updated=tmp.updated" +
            " FROM pagetext,#pagetext tmp" +
            " WHERE pagetext.id=tmp.id AND pagetext.version_id=tmp.version_id;";

        private static String sCachedQuestUpdateQueryFormat =
            "UPDATE quest SET " +
            "name_{0}=tmp.name_{0}," +
            "description_{0}=tmp.description_{0}," +
            "details_{0}=tmp.details_{0}," +
            "sub_description_{0}=tmp.sub_description_{0}," +
            "objective_1_{0}=tmp.objective_1_{0}," +
            "objective_2_{0}=tmp.objective_2_{0}," +
            "objective_3_{0}=tmp.objective_3_{0}," +
            "objective_4_{0}=tmp.objective_4_{0}," +
            "level=tmp.level," +
            "area=tmp.area," +
            "info=tmp.info," +
            "faction=tmp.faction," +
            "faction_amount=tmp.faction_amount," +
            "next_quest=tmp.next_quest," +
            "coins=tmp.coins," +
            "sub_exp_coins_70=tmp.sub_exp_coins_70," +
            "reward_spell=tmp.reward_spell," +
            "effect_on_player=tmp.effect_on_player," +
            "starting_item=tmp.starting_item," +
            "flags=tmp.flags," +
            "given_item_1=tmp.given_item_1," +
            "given_item_1_amount=tmp.given_item_1_amount," +
            "given_item_2=tmp.given_item_2," +
            "given_item_2_amount=tmp.given_item_2_amount," +
            "given_item_3=tmp.given_item_3," +
            "given_item_3_amount=tmp.given_item_3_amount," +
            "given_item_4=tmp.given_item_4," +
            "given_item_4_amount=tmp.given_item_4_amount," +
            "choice_item_1=tmp.choice_item_1," +
            "choice_item_1_amount=tmp.choice_item_1_amount," +
            "choice_item_2=tmp.choice_item_2," +
            "choice_item_2_amount=tmp.choice_item_2_amount," +
            "choice_item_3=tmp.choice_item_3," +
            "choice_item_3_amount=tmp.choice_item_3_amount," +
            "choice_item_4=tmp.choice_item_4," +
            "choice_item_4_amount=tmp.choice_item_4_amount," +
            "choice_item_5=tmp.choice_item_5," +
            "choice_item_5_amount=tmp.choice_item_5_amount," +
            "choice_item_6=tmp.choice_item_6," +
            "choice_item_6_amount=tmp.choice_item_6_amount," +
            "kill_creature_1=tmp.kill_creature_1," +
            "kill_creature_1_amount=tmp.kill_creature_1_amount," +
            "collect_item_1=tmp.collect_item_1," +
            "collect_item_1_amount=tmp.collect_item_1_amount," +
            "kill_creature_2=tmp.kill_creature_2," +
            "kill_creature_2_amount=tmp.kill_creature_2_amount," +
            "collect_item_2=tmp.collect_item_2," +
            "collect_item_2_amount=tmp.collect_item_2_amount," +
            "kill_creature_3=tmp.kill_creature_3," +
            "kill_creature_3_amount=tmp.kill_creature_3_amount," +
            "collect_item_3=tmp.collect_item_3," +
            "collect_item_3_amount=tmp.collect_item_3_amount," +
            "kill_creature_4=tmp.kill_creature_4," +
            "kill_creature_4_amount=tmp.kill_creature_4_amount," +
            "collect_item_4=tmp.collect_item_4," +
            "collect_item_4_amount=tmp.collect_item_4_amount," +
            "updated_id=tmp.updated_id," +
            "updated=tmp.updated" +
            " FROM quest,#quest tmp" +
            " WHERE quest.id=tmp.id AND quest.version_id=tmp.version_id;";

        private static String sPlayerUpdateQueryFormat =
            //"owner_id={0}," +
            "UPDATE player SET " +            
            "weapon_skill_rating={1}," +
            "defense_skill_rating={2}," +
            "dodge_rating={3}," +
            "parry_rating={4}," +
            "block_rating={5}," +
            "melee_hit_rating={6}," +
            "ranged_hit_rating={7}," +
            "spell_hit_rating={8}," +
            "melee_crit_rating={9}," +
            "ranged_crit_rating={10}," +
            "spell_crit_rating={11}," +
            "melee_hit_taken_rating={12}," +
            "ranged_hit_taken_rating={13}," +
            "spell_hit_taken_rating={14}," +
            "melee_crit_taken_rating={15}," +
            "ranged_crit_taken_rating={16}," +
            "spell_crit_taken_rating={17}," +
            "melee_haste_rating={18}," +
            "ranged_haste_rating={19}," +
            "spell_haste_rating={20}," +
            "weapon_skill_main_rating={21}," +
            "weapon_skill_off_rating={22}," +
            "weapon_skill_ranged_rating={23}," +
            "expertise_rating={24}," +
            "melee_main_skill={25}," +
            "melee_off_skill={26}," +
            "melee_main_min_damage={27}," +
            "melee_main_max_damage={28}," +
            "melee_off_min_damage={29}," +
            "melee_off_max_damage={30}," +
            "melee_main_speed={31}," +
            "melee_off_speed={32}," +
            "melee_power={33}," +
            "melee_power_bonus={34}," +
            "melee_crit={35}," +
            "defense={36}," +
            "defense_bonus={37}," +
            "dodge={38}," +
            "parry={39}," +
            "block={40}," +
            "max_health={41}," +
            "max_power={42}," +
            "money={43}," +
            "gender={44}," +
            "level={45}," +
            "race_id={46}," +
            "class_id={47}," +
            "guild_id={48}," +
            "guild_rank={49}," +
            "to_level={50}," +
            "spell_holy_damage_bonus={51}," +
            "spell_fire_damage_bonus={52}," +
            "spell_nature_damage_bonus={53}," +
            "spell_frost_damage_bonus={54}," +
            "spell_shadow_damage_bonus={55}," +
            "spell_arcane_damage_bonus={56}," +
            "spell_healing_bonus={57}," +
            "spell_holy_crit_bonus={58}," +
            "spell_fire_crit_bonus={59}," +
            "spell_nature_crit_bonus={60}," +
            "spell_frost_crit_bonus={61}," +
            "spell_shadow_crit_bonus={62}," +
            "spell_arcane_crit_bonus={63}," +
            "spell_penetration={64}," +
            "spell_mp5_notcasting={65}," +
            "spell_mp5_casting={66}," +
            "ranged_skill={67}," +
            "ranged_min_damage={68}," +
            "ranged_max_damage={69}," +
            "ranged_speed={70}," +
            "ranged_power={71}," +
            "ranged_power_bonus={72}," +
            "ranged_crit={73}," +
            "strength={74}," +
            "strength_mod={75}," +
            "agility={76}," +
            "agility_mod={77}," +
            "stamina={78}," +
            "stamina_mod={79}," +
            "intellect={80}," +
            "intellect_mod={81}," +
            "spirit={82}," +
            "spirit_mod={83}," +
            "armor={84}," +
            "armor_mod={85}," +
            "holy={86}," +
            "holy_mod={87}," +
            "fire={88}," +
            "fire_mod={89}," +
            "nature={90}," +
            "nature_mod={91}," +
            "frost={92}," +
            "frost_mod={93}," +
            "shadow={94}," +
            "shadow_mod={95}," +
            "arcane={96}," +
            "arcane_mod={97}," +
            "updated=GETUTCDATE()" +
            " WHERE id={98};";

        private static String sPlayerInsertQueryFormat =
            "INSERT INTO player(" +
            "name,server_id,owner_id," +
            "weapon_skill_rating,defense_skill_rating,dodge_rating,parry_rating,block_rating," +
            "melee_hit_rating,ranged_hit_rating,spell_hit_rating," +
            "melee_crit_rating,ranged_crit_rating,spell_crit_rating," +
            "melee_hit_taken_rating,ranged_hit_taken_rating,spell_hit_taken_rating," +
            "melee_crit_taken_rating,ranged_crit_taken_rating,spell_crit_taken_rating," +
            "melee_haste_rating,ranged_haste_rating,spell_haste_rating," +
            "weapon_skill_main_rating,weapon_skill_off_rating,weapon_skill_ranged_rating,expertise_rating," +
            "melee_main_skill,melee_off_skill," +
            "melee_main_min_damage,melee_main_max_damage,melee_off_min_damage,melee_off_max_damage," +
            "melee_main_speed,melee_off_speed," +
            "melee_power,melee_power_bonus,melee_crit," +
            "defense,defense_bonus,dodge,parry,block," +
            "max_health,max_power,money,gender,level,race_id,class_id,guild_id,guild_rank,to_level," +
            "spell_holy_damage_bonus,spell_fire_damage_bonus,spell_nature_damage_bonus,spell_frost_damage_bonus,spell_shadow_damage_bonus,spell_arcane_damage_bonus,spell_healing_bonus," +
            "spell_holy_crit_bonus,spell_fire_crit_bonus,spell_nature_crit_bonus,spell_frost_crit_bonus,spell_shadow_crit_bonus,spell_arcane_crit_bonus," +
            "spell_penetration,spell_mp5_notcasting,spell_mp5_casting," +
            "ranged_skill,ranged_min_damage,ranged_max_damage,ranged_speed,ranged_power,ranged_power_bonus,ranged_crit," +
            "strength,strength_mod,agility,agility_mod,stamina,stamina_mod,intellect,intellect_mod,spirit,spirit_mod," +
            "armor,armor_mod,holy,holy_mod,fire,fire_mod,nature,nature_mod,frost,frost_mod,shadow,shadow_mod,arcane,arcane_mod" +
            ") OUTPUT INSERTED.id VALUES (" +
            "{0},{1},{2}," +
            "{3},{4},{5},{6},{7}," +
            "{8},{9},{10}," +
            "{11},{12},{13}," +
            "{14},{15},{16}," +
            "{17},{18},{19}," +
            "{20},{21},{22}," +
            "{23},{24},{25},{26}," +
            "{27},{28}," +
            "{29},{30},{31},{32}," +
            "{33},{34}," +
            "{35},{36},{37}," +
            "{38},{39},{40},{41},{42}," +
            "{43},{44},{45},{46},{47},{48},{49},{50},{51},{52}," +
            "{53},{54},{55},{56},{57},{58},{59}," +
            "{60},{61},{62},{63},{64},{65}," +
            "{66},{67},{68}," +
            "{69},{70},{71},{72},{73},{74},{75}," +
            "{76},{77},{78},{79},{80},{81},{82},{83},{84},{85}," +
            "{86},{87},{88},{89},{90},{91},{92},{93},{94},{95},{96},{97},{98},{99});";

        private static String sPlayerEquipmentInsertQueryFormat =
            "INSERT INTO player_equipment(" +
            "player_id,slot,item_id,enchantment,jewel_0,jewel_1,jewel_2,jewel_3,suffix) VALUES(" +
            "{0},{1},{2},{3},{4},{5},{6},{7},{8});";

        private static String sPlayerFactionInsertQueryFormat =
            "INSERT INTO player_faction(" +
            "player_id,faction_id,tier,level,atwar) VALUES(" +
            "{0},{1},{2},{3},{4});";

        private static String sPlayerSkillInsertQueryFormat =
            "INSERT INTO player_skill(" +
            "player_id,skill_line_id,skill_level,skill_cap) VALUES(" +
            "{0},{1},{2},{3});";

        private static String sPlayerRecentItemDeleteQueryFormat =
            "DELETE FROM player_item_history WHERE player_id={0} AND item_id IN (" +
            "SELECT TOP(DBO.HIGHEST(0,(" +
            "SELECT {1} + COUNT(0) - 10 FROM player_item_history WHERE player_id={0}))) " +
            "item_id FROM player_item_history WHERE player_id={0} ORDER BY posted);";
        private static String sPlayerRecentItemInsertQueryFormat =
            "UPDATE player_item_history SET posted=GETUTCDATE()" +
            " WHERE player_id={0} AND item_id={1}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO player_item_history(" +
            "player_id,item_id) VALUES({0},{1});";

        private static String sPlayerPetInsertQueryFormat =            
            "INSERT INTO player_pet(" +
            "player_id,spell_id,type) VALUES({0},{1},{2});";

        private static String sPlayerAchievementInsertQueryFormat =
            "INSERT INTO player_achievement(" +
            "player_id,achievement_id) VALUES({0},{1});";

        private static String sNPCUpdateQueryFormat =
            "UPDATE creature SET " +
            "faction={0}," +
            "min_level=DBO.LOWEST(min_level,{1})," +
            "max_level=DBO.HIGHEST(max_level,{2})," +
            "level_sum=level_sum+{3}," +
            "level_count=level_count+{4}," +
            "min_health=DBO.LOWEST(min_health,{5})," +
            "max_health=DBO.HIGHEST(max_health,{6})," +
            "health_sum=health_sum+{7}," +
            "health_count=health_count+{8}," +
            "observation_count=observation_count+{9}," +
            "updated_id={10}," +
            "updated=GETUTCDATE()" +
            " WHERE id={11} AND version_id={12};";

        private static String sNPCReactionQueryFormat =
            "UPDATE creature_faction_reaction SET " +
            "reaction={0}," +
            "updated_id={1}," +
            "updated=GETUTCDATE()" +
            " WHERE creature_id={2} AND faction_id={3}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO creature_faction_reaction(" +
            "creature_id,faction_id,reaction,posted_id,updated_id) VALUES(" +
            "{2},{3},{0},{1},{1});";

        private static String sNPCLocationQueryFormat =
            "UPDATE creature_location SET " +
            "recorded=recorded+1," +
            "updated_id={0}," +
            "updated=GETUTCDATE()" +
            " WHERE creature_id={1} AND area_id={2}" +
            " AND pos_x={3} AND pos_y={4}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO creature_location(" +
            "creature_id,area_id," +
            "pos_x,pos_y,raw_pos_x,raw_pos_y,recorded,updated_id,posted_id) VALUES(" +
            "{1},{2},{3},{4},{5},{6},1,{0},{0});";

        private static String sNPCLootCountQueryFormat =
            "UPDATE creature_loot_count SET " +
            "count=count+{4}," +
            "updated_id={0}," +
            "updated=GETUTCDATE()" +
            " WHERE creature_id={1} AND loot_type={2} AND mode={3}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO creature_loot_count(" +
            "creature_id,loot_type,mode,count,posted_id,updated_id) VALUES(" +
            "{1},{2},{3},1,{0},{0});";

        private static String sNPCCoinQueryFormat =
            "UPDATE creature_coin SET " +
            "amount=amount+{0}," +
            "updated_id={1}," +
            "updated=GETUTCDATE()" +
            " WHERE creature_id={2} AND loot_type={3}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO creature_coin(" +
            "creature_id,loot_type,amount,posted_id,updated_id) VALUES(" +
            "{2},{3},{0},{1},{1});";

        private static String sNPCLootQueryFormat =
            "UPDATE creature_loot SET " +
            "modes=modes|{0}," +
            "total=total+1," +
            "stack_min=DBO.LOWEST(stack_min,{1})," +
            "stack_max=DBO.HIGHEST(stack_max,{1})," +
            "updated_id={2}," +
            "updated=GETUTCDATE()" +
            " WHERE creature_id={3} AND item_id={4} AND loot_type={5}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO creature_loot(" +
            "creature_id,item_id,loot_type," +
            "modes,total,stack_min,stack_max,posted_id,updated_id) VALUES(" +
            "{3},{4},{5},{0},1,{1},{1},{2},{2});";

        private static String sNPCMerchandiseInsertQueryFormat =
            "INSERT INTO creature_merchandise(" +
            "creature_id,item_id,amount,posted_id,updated_id) VALUES(" +
            "{0},{1},{2},{3},{3});";

        private static String sNPCMerchandiseCostInsertQueryFormat =
            "INSERT INTO creature_merchandise_cost(" +
            "creature_id,item_id,arena,honor,rating,item_1,item_1_amount,item_2,item_2_amount,item_3,item_3_amount,posted_id,updated_id) VALUES(" +
            "{0},{1},{2},{3},{4},{5},{6},{7},{7},{9},{10},{11},{11});";

        private static String sNPCLimitedMerchandiseInsertQueryFormat =
            "INSERT INTO creature_limited_merchandise(" +
            "creature_id,version_id,item_id,amount,posted_id,updated_id) VALUES(" +
            "{0},{1},{2},{3},{4},{4});";


        private static String sNPCTrainedSkillInsertQueryFormat =
            "INSERT INTO creature_trained_skill(" +
            "creature_id,spell_id,posted_id,updated_id) VALUES(" +
            "{0},{1},{2},{2});";

        private static String sNPCSpellsQueryFormat =
            "UPDATE creature_spells SET " +
            "modes=modes|{0}," +
            "updated_id={1}," +
            "updated=GETUTCDATE()" +
            " WHERE creature_id={2} AND spell_id={3}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO creature_spells(" +
            "creature_id,spell_id,modes," +
            "posted_id,updated_id) VALUES(" +
            "{2},{3},{0},{1},{1});";

        private static String sGameObjectLocationQueryFormat =
            "UPDATE gameobject_location SET " +
            "recorded=recorded+1," +
            "updated_id={0}," +
            "updated=GETUTCDATE()" +
            " WHERE object_id={1} AND area_id={2}" +
            " AND pos_x={3} AND pos_y={4}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO gameobject_location(" +
            "object_id,area_id," +
            "pos_x,pos_y,raw_pos_x,raw_pos_y,recorded,updated_id,posted_id) VALUES(" +
            "{1},{2},{3},{4},{5},{6},1,{0},{0});";

        private static String sGameObjectLootCountQueryFormat =
            "UPDATE gameobject_loot_count SET " +
            "count=count+1," +
            "updated_id={0}," +
            "updated=GETUTCDATE()" +
            " WHERE object_id={1} AND loot_type={2}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO gameobject_loot_count(" +
            "object_id,loot_type,count,posted_id,updated_id) VALUES(" +
            "{1},{2},1,{0},{0});";

        private static String sGameObjectCoinQueryFormat =
            "UPDATE gameobject_coin SET " +
            "amount=amount+{0}," +
            "updated_id={1}," +
            "updated=GETUTCDATE()" +
            " WHERE object_id={2} AND loot_type={3}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO gameobject_coin(" +
            "object_id,loot_type,amount,posted_id,updated_id) VALUES(" +
            "{2},{3},{0},{1},{1});";

        private static String sGameObjectLootQueryFormat =
            "UPDATE gameobject_loot SET " +
            "total=total+1," +
            "stack_min=DBO.LOWEST(stack_min,{0})," +
            "stack_max=DBO.HIGHEST(stack_max,{0})," +
            "updated_id={1}," +
            "updated=GETUTCDATE()" +
            " WHERE object_id={2} AND item_id={3} AND loot_type={4}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO gameobject_loot(" +
            "object_id,item_id,loot_type," +
            "total,stack_min,stack_max,posted_id,updated_id) VALUES(" +
            "{2},{3},{4},1,{0},{0},{1},{1});";

        private static String sItemLootCountQueryFormat =
            "UPDATE item_loot_count SET " +
            "count=count+1," +
            "updated_id={0}," +
            "updated=GETUTCDATE()" +
            " WHERE item_id={1} AND loot_type={2}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO item_loot_count(" +
            "item_id,loot_type,count,posted_id,updated_id) VALUES(" +
            "{1},{2},1,{0},{0});";

        private static String sItemCoinQueryFormat =
            "UPDATE item_coin SET " +
            "amount=amount+{0}," +
            "updated_id={1}," +
            "updated=GETUTCDATE()" +
            " WHERE item_id={2} AND loot_type={3}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO item_coin(" +
            "item_id,loot_type,amount,posted_id,updated_id) VALUES(" +
            "{2},{3},{0},{1},{1});";

        private static String sItemLootQueryFormat =
            "UPDATE item_loot SET " +
            "total=total+1," +
            "stack_min=DBO.LOWEST(stack_min,{0})," +
            "stack_max=DBO.HIGHEST(stack_max,{0})," +
            "updated_id={1}," +
            "updated=GETUTCDATE()" +
            " WHERE source_item_id={2} AND item_id={3} AND loot_type={4}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO item_loot(" +
            "source_item_id,item_id,loot_type," +
            "total,stack_min,stack_max,posted_id,updated_id) VALUES(" +
            "{2},{3},{4},1,{0},{0},{1},{1});";
        /*
        private static String sQuestUpdateQueryFormat =
            "UPDATE quest SET " +
            "mid_text_{0}=DBO.IFNOTNULLSTRING(mid_text_{0},{1})," +
            "end_text_{0}=DBO.IFNOTNULLSTRING(end_text_{0},{2})," +
            "min_level=DBO.LOWEST(min_level,{3})," +
            "given_to_races=given_to_races|{4}," +
            "given_to_classes=given_to_classes|{5}," +
            "starting_type=DBO.IFNOTNULLINT(starting_type,{6})," +
            "starting_id=DBO.IFNOTNULLINT(starting_id,{7})," +
            "finishing_type=DBO.IFNOTNULLINT(finishing_type,{8})," +
            "finishing_id=DBO.IFNOTNULLINT(finishing_id,{9})," +
            "timer={10}," +
            "updated_id={11}," +
            "updated=GETUTCDATE()" +
            " WHERE id={12} AND version_id={13};";
         */

        private static String sQuestUpdateQueryFormat =
        "UPDATE quest SET " +
        "mid_text_{0}=DBO.IFNOTNULLSTRING(mid_text_{0},{1})," +
        "end_text_{0}=DBO.IFNOTNULLSTRING(end_text_{0},{2})," +
        "min_level=DBO.LOWEST(min_level,{3})," +
        "given_to_races=given_to_races|{4}," +
        "given_to_classes=given_to_classes|{5}," +
        "starting_type=DBO.IFNOTNULLINT(starting_type,{6})," +
        "starting_id=DBO.IFNOTNULLINT(starting_id,{7})," +
        "finishing_type=DBO.IFNOTNULLINT(finishing_type,{8})," +
        "finishing_id=DBO.IFNOTNULLINT(finishing_id,{9})," +
        "timer={10}," +
        "updated_id={11}," +
        "updated={12}" +
        " WHERE id={13} AND version_id={14};";

        private static String sQuestExperienceQueryFormat =
            "UPDATE quest_experience_gain SET " +
            "gain={0}," +
            "updated_id={1}," +
            "updated=GETUTCDATE()" +
            " WHERE quest_id={2} AND version_id={3} AND level={4}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO quest_experience_gain(" +
            "quest_id,version_id,level,gain,posted_id,updated_id) VALUES(" +
            "{2},{3},{4},{0},{1},{1});";

        private static String sQuestFactionQueryFormat =
            "UPDATE quest_faction_change SET " +
            "amount={0}," +
            "classes=classes|{1}," +
            "races=races|{2}," +
            "updated_id={3}," +
            "updated=GETUTCDATE()" +
            " WHERE quest_id={4} AND version_id={5} AND faction_id={6}" +
            " IF @@ROWCOUNT = 0 " +
            "INSERT INTO quest_faction_change(" +
            "quest_id,version_id,faction_id,amount,classes,races,posted_id,updated_id) VALUES(" +
            "{4},{5},{6},{0},{1},{2},{3},{3});";
    }
}
