﻿using Curse;
using Curse.WoW;
using Curse.WoW.WDB;
using WoWDataCenter.DBC;
using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Text;

namespace WoWDataCenter
{
    public static partial class DB
    {
        public static void LoadQuestSchemaOrdinals()
        {
            sQuestOrdinalId = sQuestSchema.Columns.IndexOf("id");
            sQuestOrdinalVersionId = sQuestSchema.Columns.IndexOf("version_id");
            sQuestOrdinalLevel = sQuestSchema.Columns.IndexOf("level");
            sQuestOrdinalMinLevel = sQuestSchema.Columns.IndexOf("min_level");
            sQuestOrdinalGivenToClasses = sQuestSchema.Columns.IndexOf("given_to_classes");
            sQuestOrdinalGivenToRaces = sQuestSchema.Columns.IndexOf("given_to_races");
            sQuestOrdinalArea = sQuestSchema.Columns.IndexOf("area");
            sQuestOrdinalInfo = sQuestSchema.Columns.IndexOf("info");
            sQuestOrdinalStartingType = sQuestSchema.Columns.IndexOf("starting_type");
            sQuestOrdinalStartingId = sQuestSchema.Columns.IndexOf("starting_id");
            sQuestOrdinalFinishingType = sQuestSchema.Columns.IndexOf("finishing_type");
            sQuestOrdinalFinishingId = sQuestSchema.Columns.IndexOf("finishing_id");
            sQuestOrdinalTimer = sQuestSchema.Columns.IndexOf("timer");
            sQuestOrdinalFaction = sQuestSchema.Columns.IndexOf("faction");
            sQuestOrdinalFactionAmount = sQuestSchema.Columns.IndexOf("faction_amount");
            sQuestOrdinalNextQuest = sQuestSchema.Columns.IndexOf("next_quest");
            sQuestOrdinalCoins = sQuestSchema.Columns.IndexOf("coins");
            sQuestOrdinalSubExpCoins70 = sQuestSchema.Columns.IndexOf("sub_exp_coins_70");
            sQuestOrdinalRewardSpell = sQuestSchema.Columns.IndexOf("reward_spell");
            sQuestOrdinalEffectOnPlayer = sQuestSchema.Columns.IndexOf("effect_on_player");
            sQuestOrdinalStartingItem = sQuestSchema.Columns.IndexOf("starting_item");
            sQuestOrdinalFlags = sQuestSchema.Columns.IndexOf("flags");
            sQuestOrdinalGivenItem = sQuestSchema.Columns.IndexOf("given_item_1");
            sQuestOrdinalGivenItemAmount = sQuestSchema.Columns.IndexOf("given_item_1_amount");
            sQuestOrdinalChoiceItem = sQuestSchema.Columns.IndexOf("choice_item_1");
            sQuestOrdinalChoiceItemAmount = sQuestSchema.Columns.IndexOf("choice_item_1_amount");
            sQuestOrdinalTaskKill = sQuestSchema.Columns.IndexOf("kill_creature_1");
            sQuestOrdinalTaskKillAmount = sQuestSchema.Columns.IndexOf("kill_creature_1_amount");
            sQuestOrdinalTaskCollect = sQuestSchema.Columns.IndexOf("collect_item_1");
            sQuestOrdinalTaskCollectAmount = sQuestSchema.Columns.IndexOf("collect_item_1_amount");
            sQuestOrdinalPostedId = sQuestSchema.Columns.IndexOf("posted_id");
            sQuestOrdinalUpdatedId = sQuestSchema.Columns.IndexOf("updated_id");
            sQuestOrdinalPosted = sQuestSchema.Columns.IndexOf("posted");
            sQuestOrdinalUpdated = sQuestSchema.Columns.IndexOf("updated");
        }

        /**
         * Publically exposed method for updating cached quests
         * 
         * @param  pUserId   the id of the user sending the update
         * @param  pHost     the host of the user updating in IP format
         * @param  pVersion  the wow version
         * @param  pLocale   the locale
         * @param  pQuests   the list of quests contained in the update
         */
        public static void UpdateCachedQuests(Int32 pUserId,
                                              String pHost,
                                              UInt16 pVersion,
                                              ELocale pLocale,
                                              PackableList<WQSTQuest> pQuests)
        {

#if ALPHA
            CPUMonitor monitorTotal = new CPUMonitor("UpdateCachedQuests for {0} entries", pQuests.Count);
#endif

            if (pQuests.Count == 0)
            {
                return;
            }

            DataRow dr = null;
            DataTable dtInsert = sQuestSchema.Clone();
            DataTable dtUpdate = sQuestSchema.Clone();

            dtInsert.BeginLoadData();
            dtUpdate.BeginLoadData();

            CustomKey key;
            String locale = pLocale.ToString();
            using (SqlConnection conn = new SqlConnection(Config.Instance.WoWDB))
            {
                conn.Open();
                SqlBulkCopy bulkInsert = new SqlBulkCopy(conn,
                                                         SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                         null);
                SqlBulkCopy bulkUpdate = new SqlBulkCopy(conn,
                                                         SqlBulkCopyOptions.UseInternalTransaction | SqlBulkCopyOptions.TableLock,
                                                         null);
                bulkInsert.BatchSize = 5000;
                bulkUpdate.BatchSize = 5000;
                bulkInsert.DestinationTableName = "quest";
                bulkUpdate.DestinationTableName = "#quest";

                foreach (WQSTQuest quest in pQuests)
                {
                    if (!ReadyForDB(sQuestHistory,
                                    sQuestConfirmations,
                                    quest.Id,
                                    Config.Instance.QuestExpiration,
                                    Config.Instance.MinConfirmations,
                                    pUserId,
                                    pVersion,
                                    pLocale))
                    {
                        continue;
                    }

                    key = new CustomKey(pVersion,
                                        quest.Id);

                    if (sQuestHash.Contains(key))
                    {
                        dr = dtUpdate.NewRow();
                    }
                    else
                    {
                        dr = dtInsert.NewRow();
                    }

                    dr[sQuestOrdinalId] = quest.Id;
                    dr[sQuestOrdinalVersionId] = pVersion;
                    dr["name_" + locale] = quest.Name;
                    dr["description_" + locale] = quest.Description;
                    dr["details_" + locale] = quest.Details;
                    dr["sub_description_" + locale] = quest.SubDescription;

                    for (Int32 index = 0; index < 4; ++index)
                    {
                        if (index < quest.Objectives.Count)
                        {
                            dr["objective_" + (index + 1).ToString() + "_" + locale] = quest.Objectives[index];
                        }
                    }

                    dr[sQuestOrdinalLevel] = quest.Level;
                    dr[sQuestOrdinalGivenToClasses] = 0;
                    dr[sQuestOrdinalGivenToRaces] = 0;
                    dr[sQuestOrdinalArea] = quest.AreaOrSort;
                    dr[sQuestOrdinalInfo] = quest.InfoId;
                    dr[sQuestOrdinalStartingType] = 0;
                    dr[sQuestOrdinalStartingId] = 0;
                    dr[sQuestOrdinalFinishingType] = 0;
                    dr[sQuestOrdinalFinishingId] = 0;
                    dr[sQuestOrdinalTimer] = 0;
                    dr[sQuestOrdinalFaction] = quest.Faction;
                    dr[sQuestOrdinalFactionAmount] = quest.FactionReward;
                    dr[sQuestOrdinalNextQuest] = quest.NextQuest;
                    dr[sQuestOrdinalCoins] = quest.CoinReward;
                    dr[sQuestOrdinalSubExpCoins70] = quest.MaxLevelCoinReward;
                    dr[sQuestOrdinalRewardSpell] = quest.SpellReward;
                    dr[sQuestOrdinalEffectOnPlayer] = quest.EffectOnPlayer;
                    dr[sQuestOrdinalStartingItem] = quest.StartingItem;
                    dr[sQuestOrdinalFlags] = quest.Flags;

                    for (Int32 index = 0; index < 4; ++index)
                    {
                        if (index < quest.GivenItems.Count)
                        {
                            dr[sQuestOrdinalGivenItem + (index * 2)] = quest.GivenItems[index].Id;
                            dr[sQuestOrdinalGivenItemAmount + (index * 2)] = quest.GivenItems[index].Count;
                        }
                        else
                        {
                            dr[sQuestOrdinalGivenItem + (index * 2)] = 0;
                            dr[sQuestOrdinalGivenItemAmount + (index * 2)] = 0;
                        }
                    }
                    for (Int32 index = 0; index < 6; ++index)
                    {
                        if (index < quest.ChoiceItems.Count)
                        {
                            dr[sQuestOrdinalChoiceItem + (index * 2)] = quest.ChoiceItems[index].Id;
                            dr[sQuestOrdinalChoiceItemAmount + (index * 2)] = quest.ChoiceItems[index].Count;
                        }
                        else
                        {
                            dr[sQuestOrdinalChoiceItem + (index * 2)] = 0;
                            dr[sQuestOrdinalChoiceItemAmount + (index * 2)] = 0;
                        }
                    }
                    for (Int32 index = 0; index < 4; ++index)
                    {
                        if (index < quest.Tasks.Count)
                        {
                            dr[sQuestOrdinalTaskKill + (index * 4)] = quest.Tasks[index].KillCreature;
                            dr[sQuestOrdinalTaskKillAmount + (index * 4)] = quest.Tasks[index].KillCount;
                            dr[sQuestOrdinalTaskCollect + (index * 4)] = quest.Tasks[index].CollectItem;
                            dr[sQuestOrdinalTaskCollectAmount + (index * 4)] = quest.Tasks[index].CollectCount;
                        }
                        else
                        {
                            dr[sQuestOrdinalTaskKill + (index * 4)] = 0;
                            dr[sQuestOrdinalTaskKillAmount + (index * 4)] = 0;
                            dr[sQuestOrdinalTaskCollect + (index * 4)] = 0;
                            dr[sQuestOrdinalTaskCollectAmount + (index * 4)] = 0;
                        }
                    }

                    dr[sQuestOrdinalPostedId] = pUserId;
                    dr[sQuestOrdinalUpdatedId] = pUserId;
                    dr[sQuestOrdinalPosted] = DateTime.UtcNow;
                    dr[sQuestOrdinalUpdated] = DateTime.UtcNow;

                    if (sQuestHash.Contains(key))
                    {
                        dtUpdate.Rows.Add(dr);
                    }
                    else
                    {
                        sQuestHash.Add(key);
                        dtInsert.Rows.Add(dr);
                    }
                }

                if (dtInsert.Rows.Count > 0)
                {
#if ALPHA
                    CPUMonitor monitorBulk = new CPUMonitor("UpdateCachedQuests Bulk Insert Copy");
#endif
                    bulkInsert.WriteToServer(dtInsert);
#if ALPHA
                    Logger.Log(ELogLevel.Debug,
                               pHost,
                               monitorBulk.ToString());
#endif
                }

                if (dtUpdate.Rows.Count > 0)
                {
                    SqlCommand cmd = conn.CreateCommand();
                    cmd.CommandText = "SELECT TOP 0 * INTO #quest FROM quest;";
                    cmd.ExecuteNonQuery();
                    cmd.CommandText = "CREATE CLUSTERED INDEX PK_quest ON #quest(id,version_id);";
                    cmd.ExecuteNonQuery();
#if ALPHA
                    CPUMonitor monitorBulk = new CPUMonitor("UpdateCachedQuests Bulk Update Copy");
#endif
                    bulkUpdate.WriteToServer(dtUpdate);
#if ALPHA
                    Logger.Log(ELogLevel.Debug,
                               pHost,
                               monitorBulk.ToString());

                    CPUMonitor monitorTemp = new CPUMonitor("UpdateCachedQuests Update From Temp");
#endif
                    cmd.CommandText = String.Format(sCachedQuestUpdateQueryFormat,
                                                    locale);
                    cmd.ExecuteNonQuery();
#if ALPHA
                    Logger.Log(ELogLevel.Debug,
                               pHost,
                               monitorTemp.ToString());
#endif

                    cmd.CommandText = "DROP TABLE #quest;";
                    cmd.ExecuteNonQuery();
                }
            }
#if ALPHA
            Logger.Log(ELogLevel.Debug,
                       pHost,
                       monitorTotal.ToString());
#endif
        }


        private static Int32 sQuestOrdinalId = 0;
        private static Int32 sQuestOrdinalVersionId = 0;
        private static Int32 sQuestOrdinalLevel = 0;
        private static Int32 sQuestOrdinalMinLevel = 0;
        private static Int32 sQuestOrdinalGivenToClasses = 0;
        private static Int32 sQuestOrdinalGivenToRaces = 0;
        private static Int32 sQuestOrdinalArea = 0;
        private static Int32 sQuestOrdinalInfo = 0;
        private static Int32 sQuestOrdinalStartingType = 0;
        private static Int32 sQuestOrdinalStartingId = 0;
        private static Int32 sQuestOrdinalFinishingType = 0;
        private static Int32 sQuestOrdinalFinishingId = 0;
        private static Int32 sQuestOrdinalTimer = 0;
        private static Int32 sQuestOrdinalFaction = 0;
        private static Int32 sQuestOrdinalFactionAmount = 0;
        private static Int32 sQuestOrdinalNextQuest = 0;
        private static Int32 sQuestOrdinalCoins = 0;
        private static Int32 sQuestOrdinalSubExpCoins70 = 0;
        private static Int32 sQuestOrdinalRewardSpell = 0;
        private static Int32 sQuestOrdinalEffectOnPlayer = 0;
        private static Int32 sQuestOrdinalStartingItem = 0;
        private static Int32 sQuestOrdinalFlags = 0;
        private static Int32 sQuestOrdinalGivenItem = 0;
        private static Int32 sQuestOrdinalGivenItemAmount = 0;
        private static Int32 sQuestOrdinalChoiceItem = 0;
        private static Int32 sQuestOrdinalChoiceItemAmount = 0;
        private static Int32 sQuestOrdinalTaskKill = 0;
        private static Int32 sQuestOrdinalTaskKillAmount = 0;
        private static Int32 sQuestOrdinalTaskCollect = 0;
        private static Int32 sQuestOrdinalTaskCollectAmount = 0;
        private static Int32 sQuestOrdinalPostedId = 0;
        private static Int32 sQuestOrdinalUpdatedId = 0;
        private static Int32 sQuestOrdinalPosted = 0;
        private static Int32 sQuestOrdinalUpdated = 0;
    }
}
