﻿using System;
using System.Net.Sockets;

namespace Curse.SocketServer
{
    public class SocketAcceptPool : SocketAsyncEventArgsPool
    {

        public SocketAcceptPool(int size, EventHandler<SocketAsyncEventArgs> callback)
        {
            for (var i = 0; i < size; i++)
            {
                Add(Create(callback));
            }
        }

        private SocketAsyncEventArgs Create(EventHandler<SocketAsyncEventArgs> callback)
        {
            var acceptEventArgs = new SocketAsyncEventArgs();
            acceptEventArgs.Completed += callback;            
            return acceptEventArgs;
        }

        
    }
}
