using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Sockets;
using System.Collections.Concurrent;
using Curse.SocketInterface;

namespace Curse.SocketServer
{
    /// <summary>
    /// Represents a collection of reusable SocketAsyncEventArgs objects.  
    /// </summary>
    public class SocketAsyncEventArgsPool : ISocketEventArgsPool
    {

        private readonly ConcurrentQueue<SocketAsyncEventArgs> _pool = new ConcurrentQueue<SocketAsyncEventArgs>();
                
        /// <summary>
        /// Initializes the object pool to the specified size
        /// </summary>        
        public SocketAsyncEventArgsPool()
        {
        
        }

        /// <summary>
        /// Add a SocketAsyncEventArg instance to the pool
        /// </summary>
        /// <param name="item">The SocketAsyncEventArgs instance to add to the pool</param>
        public void Add(SocketAsyncEventArgs item)
        {
            if (item == null) { throw new ArgumentNullException("Items added to a SocketAsyncEventArgsPool cannot be null"); }
            _pool.Enqueue(item);            
        }

        /// <summary>
        /// Removes a SocketAsyncEventArgs instance from the pool
        /// </summary>
        /// <returns>The object removed from the pool</returns>
        public SocketAsyncEventArgs Get()
        {
            SocketAsyncEventArgs value = null;

            if(_pool.TryDequeue(out value))
            {
                return value;
            }

            return null;
        }

        /// <summary>
        /// The number of SocketAsyncEventArgs instances in the pool
        /// </summary>
        public int Count
        {
            get { return _pool.Count; }
        }

        public virtual bool Return(SocketAsyncEventArgs e)
        {
            if (e == null)
            {
                throw new ArgumentNullException("The SocketAsyncEventArgs is null, and cannot be returned to the pool.");
            }
            e.AcceptSocket = null;
            Add(e);
            return true;
        }

    }
}
