﻿using System;
using System.Net.Sockets;
using Curse.Logging;
using Curse.SocketInterface;

namespace Curse.SocketServer
{
    public class SocketClientPool : SocketAsyncEventArgsPool
    {
        private readonly BufferManager _bufferManager;
        public SocketClientPool(BufferManager bufferManager, int maxConnections, EventHandler<SocketAsyncEventArgs> callback)
        {
            _bufferManager = bufferManager;
            var size = maxConnections * SocketConstants.OperationsToPreallocate;

            Logger.Info("Creating a socket pool for " + maxConnections + " connections (" + size + " pooled args)");

            for (var i = 0; i < size; i++)
            {
                Add(Create(callback));
            }
        }

        private SocketAsyncEventArgs Create(EventHandler<SocketAsyncEventArgs> callback)
        {
            var acceptEventArgs = new SocketAsyncEventArgs();
            _bufferManager.SetBuffer(acceptEventArgs);
            acceptEventArgs.Completed += callback;            
            return acceptEventArgs;
        }
        
    }
}
