﻿using System;
using System.Net;
using System.Net.Sockets;
using Curse.SocketInterface;

namespace Curse.SocketServer
{
    public class SocketUdpPool : SocketAsyncEventArgsPool
    {                
        private readonly BufferManager _bufferManager;

        public SocketUdpPool(BufferManager bufferManager, int maxConnections, EventHandler<SocketAsyncEventArgs> callback)
        {
            _bufferManager = bufferManager;
            var size = maxConnections * SocketConstants.OperationsToPreallocate;

            for (var i = 0; i < size; i++)
            {
                Add(Create(callback));
            }
        }

        private SocketAsyncEventArgs Create(EventHandler<SocketAsyncEventArgs> callback)
        {
            var acceptEventArgs = new SocketAsyncEventArgs();
            _bufferManager.SetBuffer(acceptEventArgs);
            acceptEventArgs.Completed += callback;
            return acceptEventArgs;
        }        

        public override bool Return(SocketAsyncEventArgs e)
        {
            if (e == null)
            {
                throw new ArgumentNullException("e", "The SocketAsyncEventArgs parameter is null, and cannot be returned to the pool.");
            }

            e.RemoteEndPoint = null;            
            e.AcceptSocket = null;
            return base.Return(e);
        }
        
    }
}
