﻿using Curse.Diagnostics;
using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Curse.Diagnostics
{
    public static class DefaultLog
    {
#if DEBUG
        private static AsyncLogger _debugLogger = null;
#endif
        private static AsyncLogger _infoLogger = null;
        private static AsyncLogger _errorLogger = null;
        private static AsyncLogger _warningLogger = null;

        static DefaultLog()
        {
#if DEBUG
            _debugLogger = AsyncLogger.GetNewLogger("Default-Debug");
#endif
            _infoLogger = AsyncLogger.GetNewLogger("Default-Info");
            _errorLogger = AsyncLogger.GetNewLogger("Default-Error");
            _warningLogger = AsyncLogger.GetNewLogger("Default-Warning");
        }

        public static void Debug(string message)
        {
#if DEBUG
            _debugLogger.Log(message);
#endif
        }

        public static void Info(string message, bool writeToEventLog = false)
        {
            _infoLogger.Log(message, writeToEventLog, EventLogEntryType.Information);   
        }

        public static void Error(string message)
        {
            _errorLogger.Log(message);
        }

        public static void Exception(Exception ex, string message = null, bool writeToEventLog = false)
        {
            message = message ?? "Exception Occured";
            string exceptionMessage = message + Environment.NewLine + "    Message: " + ex.Message + Environment.NewLine + "    Stack Trace: " + ex.StackTrace;
            _errorLogger.Log(exceptionMessage, writeToEventLog);
        }

        public static void Warn(string message)
        {            
            _warningLogger.Log(message);
        }

        public static void WarnException(Exception ex, string message = null)
        {
            message = message ?? "Exception Occured";
            string exceptionMessage = message + Environment.NewLine + "    Message: " + ex.Message + Environment.NewLine + "    Stack Trace: " + ex.StackTrace;
            _warningLogger.Log(exceptionMessage);
        }
    }
}
