﻿using System;

namespace Curse.SocketInterface
{
    public struct ByteBuffer
    {
        public readonly byte[] Buffer;
        public readonly int Offset;
        public readonly int Count;

        public ByteBuffer(byte[] buffer, int offset, int count)
        {
            Buffer = buffer;
            Offset = offset;
            Count = count;
        }

        public byte this[int index]
        {
            get { return Buffer[Offset + index]; }
            set { Buffer[Offset + index] = value; }
        }

        public void BlockCopy(int srcOffset, Array dst, int dstOffset, int count)
        {
            System.Buffer.BlockCopy(Buffer, Offset + srcOffset, dst, dstOffset, count);
        }

        public void BlockCopy(int srcOffset, ByteBuffer dst, int dstOffset, int count)
        {
            System.Buffer.BlockCopy(Buffer, Offset + srcOffset, dst.Buffer, dst.Offset + dstOffset, count);
        }

        public void BlockCopy(int srcOffset, SocketBuffer dst, int dstOffset, int count)
        {
            System.Buffer.BlockCopy(Buffer, Offset + srcOffset, dst.Buffer, dst.Offset + dstOffset, count);
        }

        #region SetBytes

        public void SetBytes(bool value, int offset)
        {
            Buffer.SetBytes(value, Offset + offset);
        }

        public void SetBytesLE(bool value, int offset)
        {
            Buffer.SetBytesLE(value, Offset + offset);
        }

        public void SetBytesLE(ushort value, int offset)
        {
            Buffer.SetBytesLE(value, Offset + offset);
        }

        public void SetBytesLE(uint value, int offset)
        {
            Buffer.SetBytesLE(value, Offset + offset);
        }

        public void SetBytesLE(ulong value, int offset)
        {
            Buffer.SetBytesLE(value, Offset + offset);
        }

        public void SetBytesLE(short value, int offset)
        {
            Buffer.SetBytesLE(value, Offset + offset);
        }

        public void SetBytesLE(int value, int offset)
        {
            Buffer.SetBytesLE(value, Offset + offset);
        }

        public void SetBytesLE(long value, int offset)
        {
            Buffer.SetBytesLE(value, Offset + offset);
        }

        public void SetBytesBE(bool value, int offset)
        {
            Buffer.SetBytes(value, Offset + offset);
        }

        public void SetBytesBE(ushort value, int offset)
        {
            Buffer.SetBytesBE(value, Offset + offset);
        }

        public void SetBytesBE(uint value, int offset)
        {
            Buffer.SetBytesBE(value, Offset + offset);
        }

        public void SetBytesBE(ulong value, int offset)
        {
            Buffer.SetBytesBE(value, Offset + offset);
        }

        public void SetBytesBE(short value, int offset)
        {
            Buffer.SetBytesBE(value, Offset + offset);
        }

        public void SetBytesBE(int value, int offset)
        {
            Buffer.SetBytesBE(value, Offset + offset);
        }

        public void SetBytesBE(long value, int offset)
        {
            Buffer.SetBytesBE(value, Offset + offset);
        }

        #endregion

        #region GetBytes

        public bool ToBoolean(int offset)
        {
            return Buffer.ToBoolean(Offset + offset);
        }

        public bool ToBooleanLE(int offset)
        {
            return Buffer.ToBooleanLE(Offset + offset);
        }

        public ushort ToUInt16LE(int offset)
        {
            return Buffer.ToUInt16LE(Offset + offset);
        }

        public uint ToUInt32LE(int offset)
        {
            return Buffer.ToUInt32LE(Offset + offset);
        }

        public ulong ToUInt64LE(int offset)
        {
            return Buffer.ToUInt64LE(Offset + offset);
        }

        public short ToInt16LE(int offset)
        {
            return Buffer.ToInt16LE(Offset + offset);
        }

        public int ToInt32LE(int offset)
        {
            return Buffer.ToInt32LE(Offset + offset);
        }

        public long ToInt64LE(int offset)
        {
            return Buffer.ToInt64LE(Offset + offset);
        }

        public bool ToBooleanBE(int offset)
        {
            return Buffer.ToBooleanBE(Offset + offset);
        }

        public ushort ToUInt16BE(int offset)
        {
            return Buffer.ToUInt16BE(Offset + offset);
        }

        public uint ToUInt32BE(int offset)
        {
            return Buffer.ToUInt32BE(Offset + offset);
        }

        public ulong ToUInt64BE(int offset)
        {
            return Buffer.ToUInt64BE(Offset + offset);
        }

        public short ToInt16BE(int offset)
        {
            return Buffer.ToInt16BE(Offset + offset);
        }

        public int ToInt32BE(int offset)
        {
            return Buffer.ToInt32BE(Offset + offset);
        }

        public long ToInt64BE(int offset)
        {
            return Buffer.ToInt64BE(Offset + offset);
        }

        #endregion
    }
}
