﻿using System;

namespace Curse.SocketInterface
{
    public static class BytesEx
    {
        public static void BlockCopy(this Array src, int srcOffset, Array dst, int dstOffset, int count)
        {
            Buffer.BlockCopy(src, srcOffset, dst, dstOffset, count);
        }

        public static void BlockCopy(this Array src, int srcOffset, ByteBuffer dst, int dstOffset, int count)
        {
            Buffer.BlockCopy(src, srcOffset, dst.Buffer, dst.Offset + dstOffset, count);
        }

        public static void BlockCopy(this Array src, int srcOffset, SocketBuffer dst, int dstOffset, int count)
        {
            Buffer.BlockCopy(src, srcOffset, dst.Buffer, dst.Offset + dstOffset, count);
        }

        #region SetBytes

        public static void SetBytes(this byte[] bytes, bool value, int offset)
        {
            bytes[offset] = value ? (byte)1 : (byte)0;
        }

        public static void SetBytesLE(this byte[] bytes, bool value, int offset)
        {
            SetBytes(bytes, value, offset);
        }

        public static void SetBytesLE(this byte[] bytes, ushort value, int offset)
        {
            bytes[offset] = (byte)value;
            bytes[offset + 1] = (byte)(value >> 8);
        }

        public static void SetBytesLE(this byte[] bytes, uint value, int offset)
        {
            bytes[offset] = (byte)value;
            bytes[offset + 1] = (byte)(value >> 8);
            bytes[offset + 2] = (byte)(value >> 16);
            bytes[offset + 3] = (byte)(value >> 24);
        }

        public static void SetBytesLE(this byte[] bytes, ulong value, int offset)
        {
            bytes[offset] = (byte)value;
            bytes[offset + 1] = (byte)(value >> 8);
            bytes[offset + 2] = (byte)(value >> 16);
            bytes[offset + 3] = (byte)(value >> 24);
            bytes[offset + 4] = (byte)(value >> 32);
            bytes[offset + 5] = (byte)(value >> 40);
            bytes[offset + 6] = (byte)(value >> 48);
            bytes[offset + 7] = (byte)(value >> 56);
        }

        public static void SetBytesLE(this byte[] bytes, short value, int offset)
        {
            SetBytesLE(bytes, (ushort)value, offset);
        }

        public static void SetBytesLE(this byte[] bytes, int value, int offset)
        {
            SetBytesLE(bytes, (uint)value, offset);
        }

        public static void SetBytesLE(this byte[] bytes, long value, int offset)
        {
            SetBytesLE(bytes, (ulong)value, offset);
        }

        public static void SetBytesBE(this byte[] bytes, bool value, int offset)
        {
            SetBytes(bytes, value, offset);
        }

        public static void SetBytesBE(this byte[] bytes, ushort value, int offset)
        {
            bytes[offset] = (byte)(value >> 8);
            bytes[offset + 1] = (byte)value;
        }

        public static void SetBytesBE(this byte[] bytes, uint value, int offset)
        {
            bytes[offset] = (byte)(value >> 24);
            bytes[offset + 1] = (byte)(value >> 16);
            bytes[offset + 2] = (byte)(value >> 8);
            bytes[offset + 3] = (byte)value;
        }

        public static void SetBytesBE(this byte[] bytes, ulong value, int offset)
        {
            bytes[offset] = (byte)(value >> 56);
            bytes[offset + 1] = (byte)(value >> 48);
            bytes[offset + 2] = (byte)(value >> 40);
            bytes[offset + 3] = (byte)(value >> 32);
            bytes[offset + 4] = (byte)(value >> 24);
            bytes[offset + 5] = (byte)(value >> 16);
            bytes[offset + 6] = (byte)(value >> 8);
            bytes[offset + 7] = (byte)value;
        }

        public static void SetBytesBE(this byte[] bytes, short value, int offset)
        {
            SetBytesBE(bytes, (ushort)value, offset);
        }

        public static void SetBytesBE(this byte[] bytes, int value, int offset)
        {
            SetBytesBE(bytes, (uint)value, offset);
        }

        public static void SetBytesBE(this byte[] bytes, long value, int offset)
        {
            SetBytesBE(bytes, (ulong)value, offset);
        }

        #endregion

        #region GetBytes

        public static bool ToBoolean(this byte[] bytes, int offset)
        {
            return bytes[offset] != 0;
        }

        public static bool ToBooleanLE(this byte[] bytes, int offset)
        {
            return ToBoolean(bytes, offset);
        }

        public static ushort ToUInt16LE(this byte[] bytes, int offset)
        {
            return (ushort)(bytes[offset] | bytes[offset + 1] << 8);
        }

        public static uint ToUInt32LE(this byte[] bytes, int offset)
        {
            return (uint)(bytes[offset] | bytes[offset + 1] << 8 | bytes[offset + 2] << 16 | bytes[offset + 3] << 24);
        }

        public static ulong ToUInt64LE(this byte[] bytes, int offset)
        {
            var i1 = bytes[offset] | bytes[offset + 1] << 8 | bytes[offset + 2] << 16 | bytes[offset + 3] << 24;
            var i2 = bytes[offset + 4] | bytes[offset + 5] << 8 | bytes[offset + 6] << 16 | bytes[offset + 7] << 24;
            return (uint)i1 | (ulong)i2 << 32;
        }

        public static short ToInt16LE(this byte[] bytes, int offset)
        {
            return (short)ToUInt16LE(bytes, offset);
        }

        public static int ToInt32LE(this byte[] bytes, int offset)
        {
            return (int)ToUInt32LE(bytes, offset);
        }

        public static long ToInt64LE(this byte[] bytes, int offset)
        {
            return (long)ToUInt64LE(bytes, offset);
        }

        public static bool ToBooleanBE(this byte[] bytes, int offset)
        {
            return ToBoolean(bytes, offset);
        }

        public static ushort ToUInt16BE(this byte[] bytes, int offset)
        {
            return (ushort)(bytes[offset] << 8 | bytes[offset + 1]);
        }

        public static uint ToUInt32BE(this byte[] bytes, int offset)
        {
            return (uint)(bytes[offset] << 24 | bytes[offset + 1] << 16 | bytes[offset + 2] << 8 | bytes[offset + 3]);
        }

        public static ulong ToUInt64BE(this byte[] bytes, int offset)
        {
            var i1 = bytes[offset] << 24 | bytes[offset + 1] << 16 | bytes[offset + 2] << 8 | bytes[offset + 3];
            var i2 = bytes[offset + 4] << 24 | bytes[offset + 5] << 16 | bytes[offset + 6] << 8 | bytes[offset + 7];
            return (ulong)i1 << 32 | (uint)i2;
        }

        public static short ToInt16BE(this byte[] bytes, int offset)
        {
            return (short)ToUInt16BE(bytes, offset);
        }

        public static int ToInt32BE(this byte[] bytes, int offset)
        {
            return (int)ToUInt32BE(bytes, offset);
        }

        public static long ToInt64BE(this byte[] bytes, int offset)
        {
            return (long)ToUInt64BE(bytes, offset);
        }

        #endregion
    }
}
