﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Cryptography;
using System.Text;

namespace Curse.SocketInterface
{
    public class ClientSession : ISocketSession
    {
        public void Disconnect()
        {
            
        }

        public string SessionID { get; private set; }
        public SymmetricAlgorithm EncryptionAlgorithm { get; private set; }

        public ClientSession(string sessionID, SymmetricAlgorithm encryptionAlgorithm = null)
        {
            SessionID = sessionID;
            EncryptionAlgorithm = encryptionAlgorithm;            
        }

        public void Dispose()
        {
            if (EncryptionAlgorithm != null)
            {
                try
                {

                    EncryptionAlgorithm.Dispose();
                }
                catch { }
            }
        }
    }
}
