﻿using System;
using System.Net;
using System.Net.Sockets;
using System.Security.Cryptography;

namespace Curse.SocketInterface
{
    public interface ISocketInterface
    {
        void SendContract(IContract contract);
        ISocketSession Session { get; set; }        
        void RaiseDisconnect(SocketDisconnectReason reason);
        void RaiseDisconnect(SocketError error);
        bool IsAuthenticated { get; set; }
        IPAddress RemoteAddress { get; }
        SymmetricAlgorithm EncryptionAlgorithm { get; }
        bool IsHandshaken { get; set; }
        int DateLastHandshake { get; set; }
        int ClientID { get; }
        void SendPacket(IContract contract);
        void SendString(string serializedMessage);
    }
}
