﻿using Curse.Logging;
using System;
using System.Net.Sockets;
using Curse.SocketInterface.Exceptions;

namespace Curse.SocketInterface
{
    public class IncomingChannelProcessor : BaseChannelProcessor
    {
        private bool _isInitiatingCall = true;
        
        public IncomingChannelProcessor(BaseSocketInterface socketInterface, ISocketEventArgsPool socketEventArgsPool, SocketAsyncEventArgs e, ChannelType type, Socket socket)
            : base(socketInterface, socketEventArgsPool, e, type, socket)
        {

        }

        public override void ProcessReceive(SocketAsyncEventArgs e)
        {
            Trace("ProcessReceive");
            
            lock (_syncRoot)
            {
                var socketInterface = _socketInterface;
                if (!_isAlive || socketInterface == null)
                {
                    return;
                }                

                // Process the incoming data
                try
                {
                    if (!_isInitiatingCall && !socketInterface.IsAuthenticated)
                    {
                        RaiseDisconnect(SocketDisconnectReason.NotAuthenticated);
                        return;
                    }

                    if (e.SocketError != SocketError.Success)
                    {
                        RaiseDisconnect(e.SocketError);
                        return;
                    }

                    if (e.BytesTransferred == 0)
                    {
                        RaiseDisconnect(SocketDisconnectReason.NoData);
                        return;
                    }

                    _isInitiatingCall = false;

                    ProcessIncomingData(e);
                }
                catch (HeaderParseException ex)
                {
                    if (socketInterface != null)
                    {
                        if (_isInitiatingCall || socketInterface.IsAuthenticated)
                        {
                            Logger.Warn(ex, "The message header failed to parse during 'ProcessReceive' operation on the socket interface. The socket will be disconnected.",
                                new
                                {
                                    socketInterface.IsAuthenticated,
                                    IsInitiatingCall = _isInitiatingCall
                                });
                        }
                    }                                       
                    return;
                }
                catch (Exception ex)
                {                    
                    Logger.Error(ex, "An unhandled exception during the 'ProcessReceive' operation on the socket interface. The socket will be disconnected.");                    
                    RaiseDisconnect(SocketDisconnectReason.ProcessingError);                    
                    return;
                }
            }

            StartReceive(e);

        }                

    }
}
