using System;
using System.Net.Sockets;
using System.Runtime.InteropServices;

namespace Curse.SocketInterface
{

    /// <summary>
    /// This class is designed for use as the object to be assigned to the SocketAsyncEventArgs.UserToken property. 
    /// </summary>
    public class ServerSocketInterface : BaseSocketInterface
    {
        protected readonly ISocketEventArgsPool TcpPool;
        protected readonly ISocketEventArgsPool UdpPool;
        protected readonly Socket UdpSocket;

        public ServerSocketInterface(EventHandler<SocketDisconnectEventArgs> disconnectedEventHandler, int clientID, Socket tcpSocket, ISocketEventArgsPool tcpPool, Socket udpSocket, ISocketEventArgsPool udpPool)
            : base(clientID)
        {
            if (disconnectedEventHandler == null)
            {
                throw new ArgumentException("ServerSocketInterface must be supplied with a disconnected event handler.", "disconnectedEventHandler");
            }

            Disconnected += disconnectedEventHandler;
            Socket = tcpSocket;
            TcpPool = tcpPool;
            UdpPool = udpPool;
            UdpSocket = udpSocket;              
        }

        public void Initialize()
        {
            var tcpIncomingEventArgs = TcpPool.Get();
            tcpIncomingEventArgs.AcceptSocket = Socket;

            var tcpOutgoingEventArgs = TcpPool.Get();
            tcpOutgoingEventArgs.AcceptSocket = Socket;

            if (UdpSocket != null)
            {
                var udpOutgoingEventArgs = UdpPool.Get();
                udpOutgoingEventArgs.AcceptSocket = UdpSocket;
                Initialize(Socket, TcpPool, tcpOutgoingEventArgs, tcpIncomingEventArgs, UdpSocket, UdpPool, udpOutgoingEventArgs, true);
            }
            else
            {
                Initialize(Socket, TcpPool, tcpOutgoingEventArgs, tcpIncomingEventArgs, null, null, null, true);
            }                
        }
               
    }
}
