﻿using System.Net;
using System.Net.Sockets;

namespace Curse.SocketInterface
{
    public static class SocketAsyncEventArgsEx
    {
        // Update the RemoteEndPoint without allocating if it's not needed
        public static void SetRemoteEndPoint(this SocketAsyncEventArgs e, IPAddress address, int port)
        {
            var ip = e.RemoteEndPoint as IPEndPoint;
            if (ip == null)
            {
                ip = new IPEndPoint(address, port);
                e.RemoteEndPoint = ip;
            }
            else
            {
                ip.Address = address;
                ip.Port = port;
            }
        }

        // Set only the length, keeping the existing offset
        public static void SetBufferLength(this SocketAsyncEventArgs e, int length)
        {
            if (e.Count != length)
            {
                e.SetBuffer(e.Offset, length);
            }
        }

        // Get a ByteBuffer representing the space available for serializing an outgoing message
        public static ByteBuffer GetSendBuffer(this SocketAsyncEventArgs e, int size)
        {
            return new ByteBuffer(e.Buffer, e.Offset, size);
        }

        // Get a ByteBuffer representing only the received bytes
        public static ByteBuffer GetRecvBuffer(this SocketAsyncEventArgs e)
        {
            return new ByteBuffer(e.Buffer, e.Offset, e.BytesTransferred);
        }
    }
}
