﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Sockets;
using System.Text;

namespace Curse.SocketInterface
{
    public enum SocketDisconnectReason
    {
        Unknown = 1,
        NotAuthenticated,
        SocketError,
        NoData,
        ProcessingError,
        UserInitiated,
        IdleTimeout,
        HandshakeFailure,
        JoinFailure,
        Dispose
    }

    public class SocketDisconnectEventArgs : EventArgs
    {
        public SocketError SocketError
        {
            get;
            private set;
        }

        public SocketDisconnectReason DisconnectReason
        {
            get;
            private set;
        }

        public SocketDisconnectEventArgs(SocketError socketError) 
            : this(SocketDisconnectReason.SocketError, socketError)
        {
        }

        public SocketDisconnectEventArgs(SocketDisconnectReason reason)
            : this(reason, SocketError.Success)
        {
        }

        private SocketDisconnectEventArgs(SocketDisconnectReason disconnectReason, SocketError socketError)
        {            
            DisconnectReason = disconnectReason;
            SocketError = socketError;
        }
    }
}
