﻿using System.IO;
using ProtoBuf;
using ProtoBuf.Meta;

namespace Curse.SocketMessages
{
    public sealed class ContractSerializer
    {
        public static void PrepareSerializer<T>()
        {
            Serializer.PrepareSerializer<T>();
        }

        public static void Serialize<T>(Stream destination, T instance)
        {
            if (instance != null)
            {
                Model.Serialize(destination, instance);
            }
        }

        public static T Deserialize<T>(Stream source)
        {
            return (T)Model.Deserialize(source, null, typeof(T));
        }

        private static TypeModel _model;

        public static TypeModel Model
        {
            get { return _model ?? RuntimeTypeModel.Default; }
            set { _model = value; }
        }
    }
}
