﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Curse.SocketMessages
{
    public class EventArgs<T> : EventArgs
    {
        public T Value;

        public EventArgs(T value) : base()
        {
            Value = value;
        }
    }

    public class EventArgs<TA,TB> : EventArgs
    {
        public TA Value1;
        public TB Value2;

        public EventArgs(TA value1, TB value2)
            : base()
        {
            Value1 = value1;
            Value2 = value2;
        }
    }

    public class EventArgs<TA, TB, TC> : EventArgs
    {
        public TA Value1;
        public TB Value2;
        public TC Value3;

        public EventArgs(TA value1, TB value2, TC value3)
            : base()
        {
            Value1 = value1;
            Value2 = value2;
            Value3 = value3;
        }
    }
}
