﻿using System;

namespace Curse.SocketMessages
{
    /// <summary>
    /// Indicates that this class support serialization for our service stack
    /// </summary>
    public class ServiceContractAttribute : Attribute
    {
        public ServiceContractDirection Direction { get; private set; }
        public string Name { get; private set; }

        public ServiceContractAttribute()
        {
        }

        public ServiceContractAttribute(string name)
        {
            Name = name;
        }

        public ServiceContractAttribute(ServiceContractDirection direction, string name = null)
        {
            // Used to override type name for generating the type id.
            Name = name;

            // Used to override name-based request/response detection.
            Direction = direction;
        }
    }

    [Flags]
    public enum ServiceContractDirection
    {
        /// <summary>
        /// Direction no specified (should be determined by class name)
        /// </summary>
        Unknown = 0,

        /// <summary>
        /// Contract is sent from client to server
        /// </summary>
        Request = 1,

        /// <summary>
        /// Contract is sent from server to client
        /// </summary>
        Response = 2,
        
        /// <summary>
        /// Contract is sent from server to client, but not as a reply to a request.
        /// </summary>
        Notification = 4,   
     

        /// <summary>
        /// Indicates that this contract type is embedded as part of another contract
        /// </summary>
        Embedded = 65536
    }
}
