﻿using System;
using Curse.Logging;
using Newtonsoft.Json;
using Newtonsoft.Json.Linq;

namespace Curse.SocketMessages
{
    public class WebSocketContractDispatcher<T> : IWebSocketContractDispatcher where T : Contract<T>, new()
    {
        private readonly Action<T> _callback;
        private readonly string _typeName;

        public string TypeName
        {
            get { return _typeName; }
        }

        public WebSocketContractDispatcher(Action<T> callback)
        {
            _callback = callback;
            _typeName = typeof(T).Name;
        }

        public void Dispatch(JObject obj)
        {
            T contract = null;
            try
            {
                contract = obj.ToObject<T>();
            }
            catch (Exception ex)
            {
                Logger.Warn(ex, "Failed to create contract from message of type '" + _typeName + "'");
            }
            if (contract != null)
            {
                _callback(contract);
            }
        }
    }
}
