﻿using System;
using System.Threading;

namespace Curse.SocketServer.Testing
{
    public static class TestCoordinator
    {
        public const int NumberMessages = 1000;
        private static int _numberOfClients = 1;
        public const int Port = 90;
        

        private static int MessagesExpected;        
        private static int ClientMessageCounter = 0;
        
     
        public static void TrackClientMessage()
        {
            Interlocked.Increment(ref ClientMessageCounter);
        }

        public static void Reset(int messagesExpected, int numberOfClients)
        {
            _numberOfClients = numberOfClients;
            MessagesExpected = numberOfClients * messagesExpected;            
            ClientMessageCounter = 0;
            Console.Clear();
        }

        

        public static void Print()
        {            
            Console.WriteLine("Client Messages: " + ClientMessageCounter);

            if (ClientMessageCounter != MessagesExpected)
            {
                Console.WriteLine("Test Failed!");
                Console.ReadLine();
            }
            else
            {
                Console.WriteLine("Test Succeeded!");
            }

            
        }
    }

}
