﻿using System;
using System.Security.Cryptography;
using Curse.SocketInterface;
using Curse.SocketServer.Testing.Contracts;

namespace Curse.SocketServer.Testing
{
    public class TestSocketServer : SocketServer
    {
        public TestSocketServer() : base(1000, 1, false)
        {
            AddContractDispatcher<SequenceTestContract>(OnSequenceTestContract); 
            AddContractDispatcher<TestJoinRequest>(OnTestJoinRequest);
            AddContractDispatcher<TestEncryptedRequest>(OnTestEncryptedContract);
        }

        private void OnTestEncryptedContract(BaseSocketInterface socket, TestEncryptedRequest request)
        {
            socket.SendContract(new TestNormalResponse{ Message = request.Message });            
        }

        private void OnTestJoinRequest(BaseSocketInterface socket, TestJoinRequest request)
        {
            var response = new TestJoinResponse();
            response.ServerTime = DateTime.UtcNow;
            
            if (request.PublicKey != null)
            {
                var encryptionAlgorithm = new AesCryptoServiceProvider();
                response.EncryptedSessionKey = CryptoHelper.CreateSecret(encryptionAlgorithm, request.PublicKey);
                socket.Session = new ClientSession("Test", encryptionAlgorithm);
            }
            socket.SendContract(response);            
        }


        protected override void OnConnected(ServerSocketInterface socket)
        {
            socket.IsAuthenticated = true;
            socket.IsHandshaken = true;
            socket.Session = new ClientSession("Test");
        }

        private void OnSequenceTestContract(BaseSocketInterface baseSocketInterface, SequenceTestContract testContract)
        {            
            baseSocketInterface.DateLastHandshake = DateTime.UtcNow;            
            baseSocketInterface.SendContract(testContract);
        }
    }
}
