﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Threading;
using System.Threading.Tasks;
using Curse.SocketInterface;
using Curse.SocketMessages;
using Curse.SocketServer.Testing;

namespace Curse.SocketServer.Tester
{
    class Program
    {
        private static byte[] _testBytes;
        private const int NumberClients = 100;

        static void Main(string[] args)
        {


            Console.WriteLine("Waiting for server to start...");
            Thread.Sleep(1000);
            _testBytes = Enumerable.Repeat((byte)1, 520).ToArray();

            var client = new TestSocketClient(IPAddress.Loopback, TestCoordinator.Port);
            client.Connect();
            //client.SendContract(new TestEncryptedRequest { SequenceNumber = 1, Message = "Hello world!" } );
            new Thread(() => SendEncryptedMessages(client)) { IsBackground = true }.Start();

            //new Thread(SendMultiClientMessages) { IsBackground = true }.Start();


            Console.ReadLine();
            //client.Disconnect(SocketDisconnectReason.UserInitiated);            

        }


        private static void SendEncryptedMessages(TestSocketClient client)
        {
            while (true)
            {
                TestCoordinator.Reset(TestCoordinator.NumberMessages, 1);
                Console.WriteLine("Test starting in 1 seconds...");
                Thread.Sleep(1000);

                for (var i = 0; i < TestCoordinator.NumberMessages; i++)
                {
                    client.SendContract(new TestEncryptedRequest { SequenceNumber = i, Message = "Test " + i });
                }

                Thread.Sleep(1000);
                TestCoordinator.Print();
                Thread.Sleep(1000);
            }
        }


        private static void SendSequentialMessages(TestSocketClient client)
        {
            while (true)
            {
                TestCoordinator.Reset(TestCoordinator.NumberMessages, 1);
                Console.WriteLine("Test starting in 1 seconds...");
                Thread.Sleep(1000);

                for (var i = 0; i < TestCoordinator.NumberMessages; i++)
                {
                    client.SendContract(new SequenceTestContract { SequenceNumber = i, Message = _testBytes });
                }

                Thread.Sleep(1000);
                TestCoordinator.Print();
                Thread.Sleep(1000);
            }
        }

        private static void SendParallelMessages(TestSocketClient client)
        {
            while (true)
            {
                TestCoordinator.Reset(TestCoordinator.NumberMessages, 1);
                Console.WriteLine("Test starting in 1 seconds...");
                Thread.Sleep(1000);

                var list = new List<SequenceTestContract>();

                for (var i = 0; i < TestCoordinator.NumberMessages; i++)
                {
                    list.Add(new SequenceTestContract { SequenceNumber = i, Message = _testBytes });
                }


                Parallel.ForEach(list, (contract, state, arg3) => client.SendContract(contract));
                Thread.Sleep(1000);
                TestCoordinator.Print();
                Thread.Sleep(1000);
            }
        }

        private static void SendMultiClientMessages()
        {
            while (true)
            {
                Console.WriteLine("Test completed! Next test starting in 1 seconds...");
                Thread.Sleep(1000);
                TestCoordinator.Reset(TestCoordinator.NumberMessages, NumberClients);

                var clients = new List<TestSocketClient>();

                for (var i = 0; i < NumberClients; i++)
                {
                    var client = new TestSocketClient(IPAddress.Loopback, TestCoordinator.Port);
                    client.Connect();
                    clients.Add(client);
                }

                Console.WriteLine("Clients connected! Sending messages...");

                for (var i = 0; i < TestCoordinator.NumberMessages; i++)
                {
                    foreach (var client in clients)
                    {
                        client.SendContract(new SequenceTestContract { SequenceNumber = i, Message = _testBytes });
                    }
                }

                Console.WriteLine("Waiting for messages to finish..");

                Thread.Sleep(5000);

                foreach (var client in clients)
                {
                    client.Dispose();
                }

                TestCoordinator.Print();
            }
        }
    }
}
