﻿using System;
using System.Collections.Generic;
using System.Net;
using System.Net.Sockets;
using System.Security.Cryptography;
using Curse.SocketMessages;
using Microsoft.Web.WebSockets;
using Curse.SocketInterface;
using Newtonsoft.Json;

namespace Curse.WebSocketInterface
{
    public class BaseWebSocketInterface : ISocketInterface
    {
        private readonly WebSocketHandler _socket;
        private readonly int _clientID;
        private readonly DateTime _dateCreated;

        public bool IsHandshaken { get; set; }
        public int DateLastHandshake { get; set; }

        public int ClientID 
        {
            get { return _clientID; } 
        }

        public SymmetricAlgorithm EncryptionAlgorithm
        {
            get { return null; }
        }
        
        public ISocketSession Session { get; set; }

        public bool IsAuthenticated { get; set; }

        public DateTime DateCreated
        {
            get { return _dateCreated; }
        }

        public BaseWebSocketInterface(WebSocketHandler socket, int clientID)
        {
            _socket = socket;
            _clientID = clientID;
            _dateCreated = DateTime.UtcNow;
        }

       
        public void SendContract(IContract contract)
        {
            var serializedMessage = contract.ToJsonMessage(ClientID);
            _socket.Send(serializedMessage);    
        }

        public void SendString(string serializedMessage)
        {
            _socket.Send(serializedMessage);
        }

        public void SendPacket(IContract contract)
        {
            throw new NotImplementedException("SendPacket is not supported by the web socket interface.");
        }

        public void RaiseDisconnect(SocketDisconnectReason reason)
        {
            _socket.Close();
        }

        public void RaiseDisconnect(SocketError error)
        {
            _socket.Close();
        }

      	public IPAddress RemoteAddress
        {
            get { return IPAddress.Parse(_socket.WebSocketContext.UserHostAddress); }
        }

        public void ProcessIncomingMessage(string json)
        {
            // Try to create a message from this
            if (json.Length > Message.MaxMessageSize)
            {
                throw new Exception("More data transferred (" + json.Length + ") than permitted (" + Message.MaxMessageSize + ")");
            }

           
            ContractDispatcher.TryDispatch(this, json);   

        }
    }
}
