﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace UdpTestClient
{
    public class AsyncUdpClient
    {
        private static int _idCounter = 0;
        private IPEndPoint _serverIpEndpoint;
        private int _id;

        public AsyncUdpClient(string remoteAddress, int remotePort)
        {
            _id = Interlocked.Increment(ref _idCounter);
            _serverIpEndpoint = new IPEndPoint(IPAddress.Parse(remoteAddress), remotePort);
        }

        public string SendMessageToServer(string message)
        {

            string serverResponse = string.Empty;       // The variable which we will use to store the server response

            using (UdpClient client = new UdpClient())
            {
                byte[] data = Encoding.UTF8.GetBytes("[" + _id + "] " + message);      // Convert our message to a byte array
                Console.WriteLine("Sending message....");
                client.Send(data, data.Length, _serverIpEndpoint);      // Send the date to the server
                serverResponse = Encoding.UTF8.GetString(client.Receive(ref _serverIpEndpoint));    // Retrieve the response from server as byte array and convert it to string
            }
            return serverResponse;
        }
    }
}
