﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using System.ServiceModel.Channels;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace UdpTestServer
{
    class Program
    {
        private static byte[] _buffer = new byte[2048];
        static int port = 27005;
        static Socket listener;
        static BufferManager _bufferManager;

        static void Main(string[] args)
        {

            _bufferManager = BufferManager.CreateBufferManager(1000, 1024);
            IPEndPoint ipEndPoint = new IPEndPoint(IPAddress.Any, port);
            listener = new Socket(ipEndPoint.AddressFamily, SocketType.Dgram, ProtocolType.Udp);
            listener.SetSocketOption(SocketOptionLevel.IP, SocketOptionName.PacketInformation, true);
            //listener.SetSocketOption(SocketOptionLevel.Socket, SocketOptionName.ReuseAddress, true);
            listener.Bind(ipEndPoint);

            {
                var e = new SocketAsyncEventArgs();
                byte[] buffer = _bufferManager.TakeBuffer(1024);
                e.SetBuffer(buffer, 0, buffer.Length);
                e.Completed += PacketReceived;
                e.RemoteEndPoint = new IPEndPoint(IPAddress.Any, port);                
                e.UserToken = 1;
                Receive(e);
            }


            {
                var e = new SocketAsyncEventArgs();
                byte[] buffer = _bufferManager.TakeBuffer(1024);
                e.SetBuffer(buffer, 0, buffer.Length);
                e.Completed += OtherPacketReceived;
                e.RemoteEndPoint = new IPEndPoint(IPAddress.Any, port + 1);
                e.UserToken = 2;
                Receive(e);
            }

            Thread.Sleep(System.Threading.Timeout.Infinite);
        }

        private static void OtherPacketReceived(object sender, SocketAsyncEventArgs e)
        {
            Console.WriteLine("Received on wrong one!");
            Receive(e);
        }

        private static void PacketReceived(object sender, SocketAsyncEventArgs e)
        {
            OnPacketReceived(e);
        }

        private static void OnPacketReceived(SocketAsyncEventArgs e)
        {
            // Start a new Receive operation straight away          
            byte[] arrPrefix = new byte[e.BytesTransferred];
            Buffer.BlockCopy(e.Buffer, 0, arrPrefix, 0, e.BytesTransferred);
            Receive(e);

            var message = Encoding.UTF8.GetString(arrPrefix);
            Console.WriteLine("Received message: " + message);

            var sendEvent = new SocketAsyncEventArgs();
            byte[] buffer = _bufferManager.TakeBuffer(1024);
            sendEvent.SetBuffer(buffer, 0, buffer.Length);

            byte[] data = Encoding.UTF8.GetBytes("Loopback from Server: " + message);
            Buffer.BlockCopy(data, 0, sendEvent.Buffer, 0, data.Length);

            sendEvent.Completed += PacketSent;
            sendEvent.RemoteEndPoint = e.RemoteEndPoint;
            sendEvent.UserToken = e.UserToken;
            Send(sendEvent);
        }

        private static void PacketSent(object sender, SocketAsyncEventArgs e)
        {
            _bufferManager.ReturnBuffer(e.Buffer);
        }


        static void Send(SocketAsyncEventArgs e)
        {
            try
            {
                if (!listener.SendToAsync(e))
                {
                    Console.WriteLine("WTF?!");
                }
                Console.WriteLine("Server Send on #" + e.UserToken.ToString());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                // we should only jump here when we disconnect all the clients.
            }
        }


        private static void Receive(SocketAsyncEventArgs e)
        {
            //if (e == null)
            //{
            //    e = new SocketAsyncEventArgs();
            //    byte[] buffer = _bufferManager.TakeBuffer(1024);
            //    e.SetBuffer(buffer, 0, buffer.Length);
            //    e.Completed += PacketReceived;
            //    e.RemoteEndPoint = new IPEndPoint(IPAddress.Any, port);                
            //}
            
            try
            {
                if (!listener.ReceiveMessageFromAsync(e))
                {
                    OnPacketReceived(e);
                }
                Console.WriteLine("Server Receving on #" + e.UserToken.ToString());
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.Message);
                // we should only jump here when we disconnect all the clients.
            }
        }
    }
}
