﻿using System;
using System.Configuration;
using System.Data.SqlClient;
using Curse.Extensions;
using Curse.Logging;

namespace Curse.AchievementService.Helpers
{
    public static class DatabaseUtility
    {
        private static readonly string _connectionString;

        static DatabaseUtility()
        {
            _connectionString = ConfigurationManager.ConnectionStrings["RoamingDBAchievement"].ConnectionString;

            if (!_connectionString.EndsWith(";"))
            {
                _connectionString = _connectionString + ";";
            }
        }

        public static SqlConnection GetConnection()
        {
            return GetConnection(false);
        }

        public static SqlConnection GetConnection(bool readOnly)
        {
            try
            {
                var conn = new SqlConnection(_connectionString);
                conn.Open();
                return conn;
            }
            catch (Exception exc)
            {
                Logger.Error("Unable to open database connection.", exc.GetExceptionDetails());
                throw;
            }
        }

        public static object GetOptionalString(string str)
        {
            if (string.IsNullOrEmpty(str))
            {
                return DBNull.Value;
            }

            return str;
        }

        public static object GetOptionalInt(string str)
        {
            if (string.IsNullOrEmpty(str))
            {
                return DBNull.Value;
            }

            return Convert.ToInt32(str);
        }
    }
}