﻿using System.Net.Security;
using System.ServiceModel;
using System.ServiceModel.Web;
using Curse.AchievementService.Models;

namespace Curse.AchievementService
{
    [ServiceContract(ProtectionLevel = ProtectionLevel.None)]
    public interface IAchievementService
    {
        #region Get Achievements

        [OperationContract]
        [WebGet(ResponseFormat = WebMessageFormat.Json, UriTemplate = "getAllAchievements")]
        Achievement[] GetAllAchievements();

        [OperationContract]
        [WebGet(ResponseFormat = WebMessageFormat.Json, UriTemplate = "getAchievementByID?achievementID={achievementID}")]
        Achievement GetAchievementByID(string achievementID);

        [OperationContract]
        [WebGet(ResponseFormat = WebMessageFormat.Json, UriTemplate = "getAchievementsBySiteID?siteID={siteID}&subSiteKey={subSiteKey}")]
        Achievement[] GetAchievementsBySiteID(string siteID, string subSiteKey = null);

        #endregion

        #region Add/Update/Delete Achievement

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.WrappedRequest, Method = "POST", ResponseFormat = WebMessageFormat.Json, UriTemplate = "addAchievement")]
        Achievement AddAchievement(string name, string description, string imagePath, string rules = null, string requires = null);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.WrappedRequest, Method = "POST", ResponseFormat = WebMessageFormat.Json, UriTemplate = "deleteAchievement")]
        ApiReturn DeleteAchievement(string achievementID);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.WrappedRequest, Method = "POST", ResponseFormat = WebMessageFormat.Json, UriTemplate = "updateAchievement")]
        ApiReturn UpdateAchievement(string achievementID, string status, string name = null, string description = null, string imagePath = null, string rules = null, string requires = null);

        #endregion

        #region Get Earned Achievements

        [OperationContract]
        [WebGet(ResponseFormat = WebMessageFormat.Json, UriTemplate = "getAllAchievementsByUserID?userID={userID}")]
        EarnedAchievement[] GetAllAchievementsByUserID(string userID);

        [OperationContract]
        [WebGet(ResponseFormat = WebMessageFormat.Json, UriTemplate = "getSiteAchievementsByUserID?userID={userID}&siteID={siteID}&subSiteKey={subSiteKey}")]
        EarnedAchievement[] GetSiteAchievementsByUserID(string userID, string siteID, string subSiteKey = null);

        #endregion

        #region Award/Unaward Achievement

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.WrappedRequest, Method = "POST", ResponseFormat = WebMessageFormat.Json, UriTemplate = "awardAchievement")]
        EarnedAchievement AwardAchievement(string userID, string achievementID, string siteID, string subSiteKey = null);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.WrappedRequest, Method = "POST", ResponseFormat = WebMessageFormat.Json, UriTemplate = "unawardAchievement")]
        ApiReturn UnawardAchievement(string earnedAchievementID);

        #endregion

        #region Get/Add AuthSite

        [OperationContract]
        [WebGet(ResponseFormat = WebMessageFormat.Json, UriTemplate = "getAllSites")]
        AuthSite[] GetAllSites();

        [OperationContract]
        [WebGet(ResponseFormat = WebMessageFormat.Json, UriTemplate = "getSitesBySiteID?siteID={siteID}&subSiteKey={subSiteKey}")]
        AuthSite[] GetSitesBySiteID(string siteID, string subSiteKey = null);

        [OperationContract]
        [WebGet(ResponseFormat = WebMessageFormat.Json, UriTemplate = "getSitesByAchievementID?achievementID={achievementID}")]
        AuthSite[] GetSitesByAchievementID(string achievementID);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.WrappedRequest, Method = "POST", ResponseFormat = WebMessageFormat.Json, UriTemplate = "addSite")]
        AuthSite AddSite(string externalID, string hostName, string subSiteKey = null);

        #endregion

        #region Get SiteAchievementMap

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.WrappedRequest, Method = "POST", ResponseFormat = WebMessageFormat.Json, UriTemplate = "addSiteAchievementMap")]
        ApiReturn AddSiteAchievementMap(string siteID, string achievementID);

        [OperationContract]
        [WebInvoke(BodyStyle = WebMessageBodyStyle.WrappedRequest, Method = "POST", ResponseFormat = WebMessageFormat.Json, UriTemplate = "removeSiteAchievementMap")]
        ApiReturn RemoveSiteAchievementMap(string siteID, string achievementID);

        #endregion

        #region Health Check

        [OperationContract]
        [WebInvoke(Method = "GET", UriTemplate = "/HealthCheck")]
        string HealthCheck();

        [OperationContract]
        [WebInvoke(Method = "GET", UriTemplate = "/")]
        string Index();

        #endregion
    }
}