﻿using System.Net;
using System.Runtime.Serialization;
using System.ServiceModel.Web;

namespace Curse.AchievementService.Models
{
    [DataContract]
    public class ApiError
    {
        [DataMember(Name = "errorCode")]
        public int ErrorCode { get; private set; }


        [DataMember(Name = "errorMessage")]
        public string ErrorMessage { get; private set; }

        public ApiError(int code, string message)
        {
            ErrorMessage = message;
            ErrorCode = code;
        }

        public static WebFaultException<ApiError> Create(int code, string message, HttpStatusCode statusCode = HttpStatusCode.BadRequest)
        {
            return new WebFaultException<ApiError>(new ApiError(code, message), statusCode);
        }
    }
}