﻿using System.Net;
using System.Runtime.Serialization;
using System.ServiceModel.Web;

namespace Curse.AchievementService.Models
{
    [DataContract]
    public class ApiReturn
    {
        [DataMember(Name = "returnCode")]
        public bool ReturnCode { get; private set; }


        [DataMember(Name = "returnMessage")]
        public string ReturnMessage { get; private set; }

        public ApiReturn(bool code, string message)
        {
            ReturnCode = code;
            ReturnMessage = message;
        }

        public static WebFaultException<ApiReturn> Create(bool code, string message, HttpStatusCode statusCode = HttpStatusCode.OK)
        {
            return new WebFaultException<ApiReturn>(new ApiReturn(code, message), statusCode);
        }
    }
}