﻿using System;
using System.Web;
using System.Threading;
using System.Data.SqlClient;
using System.Collections.Generic;
using AddOnService.Models;
using Curse;
using System.Data;
using System.Configuration;
using Curse.Auth;

namespace AddOnService
{
    public static class AddOnDownloadTracker
    {
                
        private static readonly int sUpdateThreadInterval = 1000 * 60 * 5; // 5 mins by default.
        private static string sConnectionString = null;
        private static Thread sWriteToDatabaseThread = null;

        private static Dictionary<int, int> sProjectDownloads = null;
        private static Dictionary<int, int> sFileDownloads = null;

        public static void Initialize()
        {            
            sConnectionString = ConfigurationManager.ConnectionStrings["RoamingDB"].ConnectionString;
            sProjectDownloads = new Dictionary<int, int>();
            sFileDownloads = new Dictionary<int, int>();
            sWriteToDatabaseThread = new Thread(WriteToDatabaseThread);
            sWriteToDatabaseThread.Start();
        }

        public static void LogFileDownload(int pProjectId, int pFileId)
        {
            lock (sProjectDownloads)
            {
                if (sProjectDownloads.ContainsKey(pProjectId))
                {
                    sProjectDownloads[pProjectId] += 1;
                }
                else
                {
                    sProjectDownloads.Add(pProjectId, 1);
                }
            }
            lock (sFileDownloads)
            {
                if (sFileDownloads.ContainsKey(pFileId))
                {
                    sFileDownloads[pFileId] += 1;
                }
                else
                {
                    sFileDownloads.Add(pFileId, 1);
                }
            }
        }

        public static void WriteToDatabaseThread()
        {
            Boolean aborted = false;
            while (!aborted)
            {
                //Every minute for now:            
                Thread.Sleep(sUpdateThreadInterval);
                try
                {
                    WriteToDatabase();
                    Logger.Log(ELogLevel.Info, null, "AddOnDownloadTracker: Project download statistics saved.");
                }
                catch (ThreadAbortException)
                {
                    aborted = true;
                }
                catch (Exception ex)
                {
                    Logger.Log(ELogLevel.Error,
                           null,
                           "AddOnDownloadTracker Error: " + ex.Message + Environment.NewLine + "Stack:" + ex.StackTrace);
                }
            }

        }

        private static void WriteToDatabase()
        {
            
            // File Downloads
            Dictionary<int, int> fileDownloads = null;            
            lock (sFileDownloads)
            {
                fileDownloads = new Dictionary<int, int>(sFileDownloads);
                sFileDownloads.Clear();
            }

            SaveFileDownloads(fileDownloads);

            // Project Downloads
            Dictionary<int, int> projectDownloads = null;

            lock (sProjectDownloads)
            {
                projectDownloads = new Dictionary<int, int>(sProjectDownloads);
                sProjectDownloads.Clear();
            }

            SaveProjectDownloads(projectDownloads);

        }

        private static void SaveProjectDownloads(Dictionary<int, int> pProjectDownloads)
        {
            if (pProjectDownloads.Count == 0)
            {
                return;
            }

            DataTable fileDownloadsTable = new DataTable();
            fileDownloadsTable.Columns.Add("id", typeof(int));
            fileDownloadsTable.Columns.Add("download_count", typeof(int));
            fileDownloadsTable.BeginLoadData();
            foreach (KeyValuePair<int, int> kvp in pProjectDownloads)
            {
                DataRow row = fileDownloadsTable.NewRow();
                row["id"] = kvp.Key;
                row["download_count"] = kvp.Value;
                fileDownloadsTable.Rows.Add(row);
            }

            using (SqlConnection conn = new SqlConnection(sConnectionString))
            {            
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "create table #tmp (id int, download_count int);";

                conn.Open();
                cmd.ExecuteNonQuery();
                using (SqlBulkCopy bulk = new SqlBulkCopy(conn, SqlBulkCopyOptions.TableLock, null))
                {
                    bulk.DestinationTableName = "#tmp";
                    bulk.WriteToServer(fileDownloadsTable);
                }

                // First curse_ProjectDownloads 
                cmd.CommandText = "update curse_ProjectDownloads set Total = Total + download_count" +
                    " from curse_ProjectDownloads, #tmp where curse_ProjectDownloads.ProjectId = #tmp.id;";
                cmd.ExecuteNonQuery();
                cmd.CommandText = "insert into curse_ProjectDownloads(ProjectId, Total, DailyAverage) select id, download_count, download_count" +
                    " from #tmp where not exists(select top 1 1 from curse_ProjectDownloads as b where b.ProjectId = #tmp.id)";
                cmd.ExecuteNonQuery();

                // Next dbo.curse_ProjectDownloadsByDay                
                cmd.CommandText = "DECLARE @StrippedDate datetime;" +
                                    "SET @StrippedDate = cast(floor(cast(getdate() as float)) as datetime);" +
                                    "update curse_ProjectDownloadsByDay set Downloads = Downloads + download_count" +
                                    " from curse_ProjectDownloadsByDay, #tmp" +
                                    " where curse_ProjectDownloadsByDay.ProjectId = #tmp.id and Date = @StrippedDate;";
                cmd.ExecuteNonQuery();
                cmd.CommandText = "DECLARE @StrippedDate datetime;" +
                                    "SET @StrippedDate = cast(floor(cast(getdate() as float)) as datetime);" +
                                    "insert into curse_ProjectDownloadsByDay(ProjectId, Date, Downloads) select id, @StrippedDate, download_count" +
                                    " from #tmp where not exists(select top 1 1 from curse_ProjectDownloadsByDay as b where b.ProjectId = #tmp.id and Date = @StrippedDate)";
                cmd.ExecuteNonQuery();

            }

        }

        private static void SaveFileDownloads(Dictionary<int, int> pFileDownloads)
        {

            if (pFileDownloads.Count == 0)
            {
                return;
            }

            DataTable fileDownloadsTable = new DataTable();
            fileDownloadsTable.Columns.Add("id", typeof(int));
            fileDownloadsTable.Columns.Add("download_count", typeof(int));
            fileDownloadsTable.BeginLoadData();

            foreach (KeyValuePair<int, int> kvp in pFileDownloads)
            {
                DataRow row = fileDownloadsTable.NewRow();
                row["id"] = kvp.Key;
                row["download_count"] = kvp.Value;
                fileDownloadsTable.Rows.Add(row);
            }

            using (SqlConnection conn = new SqlConnection(sConnectionString))
            {            
                SqlCommand cmd = conn.CreateCommand();
                cmd.CommandText = "create table #tmp (id int, download_count int);";

                conn.Open();
                cmd.ExecuteNonQuery();
                using (SqlBulkCopy bulk = new SqlBulkCopy(conn, SqlBulkCopyOptions.TableLock, null))
                {
                    bulk.DestinationTableName = "#tmp";
                    bulk.WriteToServer(fileDownloadsTable);
                }
                cmd.CommandText = "update curse_ProjectFile set Downloads = Downloads + download_count" +
                    " from curse_ProjectFile, #tmp where curse_ProjectFile.FileId = #tmp.id;";

                cmd.ExecuteNonQuery();
            }
        }
    }
}
