﻿using System;
using System.Collections.Generic;
using System.IO;
using Curse;

namespace AddOnService
{
    public class AddOnFingerprintMatch
    {
        private byte[] serialized = null;
        private byte[] serializedPartial = null;
        private AddOn mAddon = null;
        private AddOnFile mAddonFile = null;

        public int Id
        {
            get
            {
                return mAddon.Id;
            }
            
        }

        public string InstalledVersionName
        {
            get
            {
                return mAddonFile.Name;
            }
        }

        public long InstalledVersionDate
        {
            get
            {
                return mAddonFile.EpochDate;
            }
        }
       

        public List<long> Fingerprints
        {
            get
            {
                return mAddonFile.Fingerprints;
            }
        }

        public List<string> FolderNames
        {
            get
            {
                return mAddonFile.FolderNames;
            }
        }

        public EFileType ReleaseType
        {
            get
            {
                return mAddonFile.Type;
            }
         
        }        

        public bool IsAlternate
        {
            get
            {
                return mAddonFile.IsAlternate;
            }
        }

        public EFileStatus FileStatus
        {
            get
            {
                return mAddonFile.Status;
            }
        }

        public AddOnFingerprintMatch(AddOn pAddOn, AddOnFile pFile)         
        {
            mAddon = pAddOn;
            mAddonFile = pFile;
            serialized = serializeBinary();
            serializedPartial = serializeBinaryPartial();
        }

        public bool IsExactMatch(List<long> pFingerprints)
        {
            foreach (long fingerprint in Fingerprints)
            {
                if (!pFingerprints.Contains(fingerprint))
                {
                    return false;
                }
            }
            return true;
        }

        public List<long> GetPartialMatchFingerprints(List<long> pFingerprints)
        {
            List<long> partialMatches = new List<long>();
            foreach (long fingerprint in Fingerprints)
            {
                if (pFingerprints.Contains(fingerprint))
                {
                    partialMatches.Add(fingerprint);
                }
            }
            return partialMatches;
        }

        public void WriteExactMatch(Stream stream)
        {
            stream.Write(serialized, 0, serialized.Length);
        }

        public void WritePartialMatch(Stream stream)
        {
            stream.Write(serialized, 0, serialized.Length);
            stream.Write(serializedPartial, 0, serializedPartial.Length);
           
        }


        private byte[] serializeBinaryPartial()
        {
            using (MemoryStream ms = new MemoryStream(1000))
            {

                using (BinaryWriter bw = new BinaryWriter(ms))
                {
                    // Folders names count
                    bw.Write(FolderNames.Count);

                    // Folder names
                    foreach (string folderName in FolderNames)
                    {
                        Utility.WriteNetworkString(bw, folderName);
                    }
                }
                return ms.ToArray();
            }
            
        }

        private byte[] serializeBinary()
        {
            
            using (MemoryStream ms = new MemoryStream(1000))
            {

                using (BinaryWriter bw = new BinaryWriter(ms))
                {
                    // Addon ID:
                    bw.Write(Id);

                    // Installed File:
                    mAddonFile.WriteMatch(bw);

                    // Latest Releases:
                    List<AddOnFile> latestFiles = mAddon.LatestFiles;

                    // Count
                    bw.Write((byte)latestFiles.Count);
                    // File matches
                    foreach (AddOnFile latestFile in latestFiles)
                    {
                        latestFile.WriteMatch(bw);
                    }
                   
                    // Fingerprints count
                    bw.Write(Fingerprints.Count);

                    //Fingerprints
                    foreach (int fingerprint in Fingerprints)
                    {
                        bw.Write(fingerprint);
                    }

                    
                }
                return ms.ToArray();
            }

        }        
    }
}
