﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace AddOnService
{
    public class AddOnFingerprintMatchResult
    {        
        // Privates
        private List<long> mInstalledFingerprints = null;


        // Properties
        public List<AddOnFingerprintMatch> ExactMatches
        {
            get;
            set;
        }

        public List<long> ExactFingerprints
        {
            get;
            set;
        }

        public List<AddOnFingerprintMatch> PartialMatches
        {
            get;
            set;
        }

        public Dictionary<int, List<long>> PartialMatchFingerprints
        {
            get;
            set;
        }
        
        public List<long> InstalledFingerprints
        {
            get
            {
                return mInstalledFingerprints;
            }
        }

        private bool IsUnmatched(long s)
        {
            return !ExactFingerprints.Contains(s);
        }


        public List<long> UnmatchedFingerprints
        {
            get
            {                
                return InstalledFingerprints.FindAll(IsUnmatched);             
            }
        }
        
        // Constructor
        public AddOnFingerprintMatchResult(long[] pFingerprints)
        {
            mInstalledFingerprints = new List<long>(pFingerprints);
            ExactMatches = new List<AddOnFingerprintMatch>();
            PartialMatches = new List<AddOnFingerprintMatch>();
        }
    }
}
