﻿using System;
using System.Collections.Generic;
using System.Web;
using System.IO;
using Curse;

namespace AddOnService
{
    public class AddOnFuzzyMatch
    {
        private byte[] serialized = null;
        private AddOn mAddon = null;
        private AddOnFile mAddonFile = null;        
        private List<long> mFingerprints;

        public List<long> Fingerprints
        {
            get
            {
                return mFingerprints;
            }
        }

        public int Id
        {
            get
            {
                return mAddon.Id;
            }
        }

        private bool IsFuzzyMatch(long s)
        {
            return mFingerprints.BinarySearch(s) >= 0;
        }

        public int FuzzyMatchCount(List<long> pFingerprints)
        {
            return pFingerprints.FindAll(IsFuzzyMatch).Count;
        }        

        public AddOnFuzzyMatch(string pFolderName, AddOn pAddOn, AddOnFile pAddOnFile)
        {
            mAddon = pAddOn;
            mAddonFile = pAddOnFile;
            mFingerprints = pAddOnFile.FolderFingerprints[pFolderName];
            serialized = serializeBinary();
        }

        public void Write(Stream stream)
        {
            stream.Write(serialized, 0, serialized.Length);
        }

        private byte[] serializeBinary()
        {

            using (MemoryStream ms = new MemoryStream(1000))
            {

                using (BinaryWriter bw = new BinaryWriter(ms))
                {
                    // Name:
                    Utility.WriteNetworkString(bw, mAddon.Name);

                    // URL:
                    Utility.WriteNetworkString(bw, mAddon.Url);

                    // Addon ID:
                    bw.Write(Id);

                    // Installed File:
                    mAddonFile.WriteMatch(bw);

                    // Latest Releases:
                    List<AddOnFile> latestFiles = mAddon.LatestFiles;

                    // Count
                    bw.Write((byte)latestFiles.Count);
                    // File matches
                    foreach (AddOnFile latestFile in latestFiles)
                    {
                        latestFile.WriteMatch(bw);
                    }

                    // Fingerprints count
                    bw.Write(Fingerprints.Count);

                    //Fingerprints
                    foreach (int fingerprint in Fingerprints)
                    {
                        bw.Write(fingerprint);
                    }
                }
                return ms.ToArray();
            }

        }     
    }
}
