﻿using System;
using System.Web;
using System.Data;
using System.Data.SqlClient;
using System.Text;
using System.Text.RegularExpressions;
using System.Configuration;
using Curse;

namespace AddOnService
{
    public class NewsHeadline
    {

        private static string sNewsBaseUrl = ConfigurationManager.AppSettings["NewsBaseUrl"];
        private static Regex sPropertyRegex = new Regex(@"(?<Name>\w*?):(\w*?)\:(?<Start>[0-9]*?)\:(?<Length>[0-9]*?)([\:|\r])", RegexOptions.Compiled);
        private int mId = 0;
        private string mSlug = null;
        private string mHeadline = null;
        private string mBody = null;
        private string mAuthorName = null;
        private DateTime mDate;
        private string mCategoryName = null;
        private string mSubCategoryName = null;
        private string mPropertyNames = null;
        private string mPropertyValues = null;

        public NewsHeadline(SqlDataReader pReader)
        {
            mId = pReader.GetInt32(pReader.GetOrdinal("news_id"));
            mSlug = pReader.GetString(pReader.GetOrdinal("news_url_slug"));
            mHeadline = pReader.GetString(pReader.GetOrdinal("news_headline"));
            mBody = pReader.GetString(pReader.GetOrdinal("news_body"));
            mAuthorName = pReader.GetString(pReader.GetOrdinal("news_author_name"));
            mDate = pReader.GetDateTime(pReader.GetOrdinal("news_date"));
            mCategoryName = pReader.GetString(pReader.GetOrdinal("news_category_name"));
            mSubCategoryName = pReader.GetString(pReader.GetOrdinal("news_sub_category_name"));
            if(pReader["news_property_names"] != System.DBNull.Value)
            {
                mPropertyNames = pReader.GetString(pReader.GetOrdinal("news_property_names"));
            }
            if (pReader["news_property_values"] != System.DBNull.Value)
            {
                mPropertyValues = pReader.GetString(pReader.GetOrdinal("news_property_values"));
            }
            
        }

        private void AppendNewsBody(StringBuilder pBuilder)
        {
            if(mPropertyValues == null || mPropertyNames == null)
            {
                AppendTruncatedBody(pBuilder);
                return;
            }
            bool hasExcerpt = false;
            int excerptStart = 0;
            int excerptLength = 0;
            MatchCollection matches = sPropertyRegex.Matches(mPropertyNames);
            foreach (Match match in matches)
            {
                if (match.Groups["Name"].Value == "Excerpt")
                {
                    hasExcerpt = true;
                    excerptStart = int.Parse(match.Groups["Start"].Value);
                    excerptLength = int.Parse(match.Groups["Length"].Value);
                    break;
                }
            }
            if (!hasExcerpt)
            {
                AppendTruncatedBody(pBuilder);
                return;
            }
            string excerpt = mPropertyValues.Substring(excerptStart, excerptLength);
            pBuilder.AppendFormat(Environment.NewLine + "<description>{0}</description>", HttpUtility.HtmlEncode(excerpt));
        }

        private void AppendTruncatedBody(StringBuilder pBuilder)
        {
            mBody = Utility.GetStrippedHtml(mBody);

            if (Utility.GetWordCount(mBody) > 200)
            {
                mBody = HttpUtility.HtmlEncode(Utility.GetTruncatedText(Utility.GetFirstWords(mBody, 200)));
                pBuilder.AppendFormat(Environment.NewLine + "<description>{0}</description>", mBody);
            }
            else
            {
                pBuilder.AppendFormat(Environment.NewLine + "<description>{0}</description>", HttpUtility.HtmlEncode(mBody));
            }
        }

        private void AppendExcerpt(StringBuilder pBuilder)
        {

        }

        public void WriteItem(StringBuilder pBuilder)
        {

            
            pBuilder.Append(Environment.NewLine + "<item>");
            pBuilder.AppendFormat(Environment.NewLine + "<title>{0}: {1}</title>", mSubCategoryName, mHeadline);
            pBuilder.AppendFormat(Environment.NewLine + "<link>" + sNewsBaseUrl + "</link>", mSlug, mId);
            AppendNewsBody(pBuilder);
            pBuilder.AppendFormat(Environment.NewLine + "<author>{0}</author>", mAuthorName);
            pBuilder.AppendFormat(Environment.NewLine + "<pubDate>{0}</pubDate>", mDate.ToString());
            pBuilder.AppendFormat(Environment.NewLine + "<guid>" + sNewsBaseUrl + "</guid>", mSlug, mId);
            pBuilder.Append(Environment.NewLine + "</item>");
        }

    }
}
