﻿using System;
using System.Web.Routing;
using System.ServiceModel.Activation;
using System.Configuration;
using Curse.Logging;
using Curse.Logging.Uploader;


namespace Curse.DownloadStatisticService
{
    public class Global : System.Web.HttpApplication
    {
        protected void Application_Start(object sender, EventArgs e)
        {
            RouteTable.Routes.Add(new ServiceRoute("", new WebServiceHostFactory(), typeof(DownloadStatisticService)));
            Logger.Init(ConfigurationManager.AppSettings["LogPath"], "DownloadStatisticsService");
            LogUploader.Initialize(10, ConfigurationManager.AppSettings["LogServiceUrl"], ConfigurationManager.AppSettings["LogServiceApiKey"]);
            Logger.Info("Service Started");
        }

        protected void Application_End(object sender, EventArgs e)
        {
            Logger.Info("Service Ended");
            Logger.Shutdown();

        }
    }
}