﻿using System;
using System.Collections.Generic;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using Curse.DownloadStatisticService.Extensions;
using Curse.DownloadStatisticService.Models;

namespace Curse.DownloadStatisticService
{
    [ServiceContract]
    public interface IDownloadStatisticService
    {
   
        [OperationContract]
        [RequireApiKey("x-api-key", "XApiKey")]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/download-counts?modified-since={date}")]
        FileProjectCounts GetDownloadCounts(DateTime date);

        [OperationContract]
        [RequireApiKey("x-api-key", "XApiKey")]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/project-popularity?modified-since={date}")]
        ProjectPopularities GetProjectPopularity(DateTime date);

        /// <summary>
        /// Get the Unique total downloads for a given month wehn passed the first day of a month 
        /// </summary>
        /// <param name="date"> the first day of the month you want calculated</param>
        /// <returns></returns>
        [OperationContract]
        [RequireApiKey("x-api-key", "XApiKey")]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/download-for-month?date={date}")]
        int GetUniqueDownloadsForMonth(DateTime date);

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "/")]
        string HealthCheck();
    }


    [Serializable]
    [CollectionDataContract]
    [KnownType(typeof(ProjectPopularity))]
    public class ProjectPopularities : List<ProjectPopularity>
    { }

    [Serializable]
    [CollectionDataContract]
    [KnownType(typeof(FileCount))]
    public class FileCounts : List<FileCount>
    { }

    [Serializable]
    [CollectionDataContract]
    [KnownType(typeof(ProjectCount))]
    public class ProjectCounts : List<ProjectCount>
    { }

    [Serializable]
    [DataContract]
    public class FileProjectCounts
    {
        [DataMember(Name = "fileDownloadTotals", Order = 1)]
        public FileCounts FC { get; set; }

        [DataMember(Name = "projectDownloads", Order = 2)]
        public ProjectCounts PC { get; set; }
    }

}
