﻿using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.ServiceModels.Caching;
using Curse.DownloadStatisticService.Models;
using Curse.ServiceModels.Configuration;
using System.Data.SqlClient;
using Curse.Extensions;

namespace Curse.DownloadStatisticService.Caching
{
    public class ReferrerCache : IncrementalCache<Referrer>
    {
        ConcurrentDictionary<int, string> _referrerById = new ConcurrentDictionary<int, string>();

        static ReferrerCache _instance = new ReferrerCache();
        public static ReferrerCache Instance { get { return _instance; } }
        public ReferrerCache() : base("DownloadStatistics", "spGetReferrers") { }

        public override bool UpdateCache()
        {
            using (var conn = new SqlConnection(DatabaseConfiguration.Instance["DownloadStatistics"].ConnectionString))
            {
                var cmd = new SqlCommand("SELECT ID, Referrer FROM DownloadLogReferrer", conn);

                try
                {
                    conn.Open();
                    using (var reader = cmd.ExecuteReader())
                    {
                        while (reader.Read())
                        {
                            int id = reader.GetInt32(reader.GetOrdinal("ID"));
                            string referrer = reader.GetString(reader.GetOrdinal("Referrer"));

                            _referrerById.AddOrUpdate(id, referrer, (key, value) => referrer);
                        }
                    }
                }
                catch (Exception exc)
                {
                    Logger.Log("Unable to update the Referrer Cache. Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
                    return false;
                }
            }

            return true;
        }

        private static int _rf;
        public int GetIDByReferrer(string referrer)
        {
            if (String.IsNullOrEmpty(referrer)) { return 0; }

            if (referrer.Length > 512)
            {
                referrer = referrer.Substring(0, 512);
            }

            _rf = 0;
            _rf = _referrerById.FirstOrDefault(p => p.Value == referrer).Key;

            if (_rf == 0)
            {
                 //_rf = CreateReferrer(referrer);
                    using (var conn = new SqlConnection(DatabaseConfiguration.Instance["DownloadStatistics"].ConnectionString))
                    {
                        var cmd = new SqlCommand("INSERT INTO DownloadLogReferrer (Referrer) VALUES (@Referrer) SET @ID = SCOPE_IDENTITY()", conn);
                        cmd.Parameters.Add("Referrer", System.Data.SqlDbType.VarChar).Value = referrer;
                        cmd.Parameters.Add("ID", System.Data.SqlDbType.Int);
                        cmd.Parameters["ID"].Direction = System.Data.ParameterDirection.Output;

                        try
                        {
                            conn.Open();
                            cmd.ExecuteNonQuery();
                            _rf = (int)cmd.Parameters["ID"].Value;
                            _referrerById.AddOrUpdate(_rf, referrer, (key, value) => referrer);
                        }
                        catch (Exception exc)
                        {
                            Logger.Log("Failed to Create referrer ({0}). Details: {1}", ELogLevel.Error, referrer, exc.GetExceptionDetails());
                            //_referrerById.AddOrUpdate(0, referrer, (key, value) => referrer);
                        }
                    }

            }
            
            return _rf;

        }

        private static int _idCrd;
        public bool CheckReferrerData(AddDownloadLogEntryMessage message, out string returnMessage)
        {
            string referrer = String.Empty;
            if (String.IsNullOrEmpty(message.Referrer))
            {
                returnMessage = "Success";
                return true;
            }
            else if (message.Referrer.Length > 512)
            {
                referrer = message.Referrer.Substring(0, 512);
            }
            else
            {
                referrer = message.Referrer;
            }
            _idCrd = 0;
            _idCrd = _referrerById.FirstOrDefault(p => p.Value == referrer).Key;
            
                if (_idCrd == 0)
                {
                    //_idCrd = CreateReferrer(referrer);
                    using (var conn = new SqlConnection(DatabaseConfiguration.Instance["DownloadStatistics"].ConnectionString))
                    {
                        var cmd = new SqlCommand("INSERT INTO DownloadLogReferrer (Referrer) VALUES (@Referrer) SET @ID = SCOPE_IDENTITY()", conn);
                        cmd.Parameters.Add("Referrer", System.Data.SqlDbType.VarChar).Value = referrer;
                        cmd.Parameters.Add("ID", System.Data.SqlDbType.Int);
                        cmd.Parameters["ID"].Direction = System.Data.ParameterDirection.Output;

                        try
                        {
                            conn.Open();
                            cmd.ExecuteNonQuery();
                            _idCrd = (int)cmd.Parameters["ID"].Value;
                            _referrerById.AddOrUpdate(_idCrd, referrer, (key, value) => referrer);
                        }
                        catch (Exception exc)
                        {
                            Logger.Log("Failed to Create referrer ({0}). Details: {1}", ELogLevel.Error, referrer, exc.GetExceptionDetails());
                            //_referrerById.AddOrUpdate(0, referrer, (key, value) => referrer);
                        }
                    }

                    if (_idCrd == 0)
                    {
                        returnMessage = "Failed to Create Referrer record.";
                        return false;
                    }
                }
            
            returnMessage = "Success";
            return true;
        }

        private static int _idCr;
        /// <summary>
        ///  Input param: referrer should not be longer than 512 chars
        ///  <para>It does not get Substringed in this method so if you pass more than 512 this methid will return false!</para>
        /// </summary>
        /// <param name="referrer">512 char MAX!</param>
        /// <returns>true if the insert was successful or if param was null</returns>
        private int CreateReferrer(string referrer)
        {
            _idCr = 0;
            if (referrer != null)
            {
                using (var conn = new SqlConnection(DatabaseConfiguration.Instance["DownloadStatistics"].ConnectionString))
                {
                    var cmd = new SqlCommand("INSERT INTO DownloadLogReferrer (Referrer) VALUES (@Referrer) SET @ID = SCOPE_IDENTITY()", conn);
                    cmd.Parameters.Add("Referrer", System.Data.SqlDbType.VarChar).Value = referrer;
                    cmd.Parameters.Add("ID", System.Data.SqlDbType.Int);
                    cmd.Parameters["ID"].Direction = System.Data.ParameterDirection.Output;

                    try
                    {
                        conn.Open();
                        cmd.ExecuteNonQuery();
                        _idCr = (int)cmd.Parameters["ID"].Value;
                        _referrerById.AddOrUpdate(_idCr, referrer, (key, value) => referrer);
                    }
                    catch (Exception exc)
                    {
                        Logger.Log("Failed to Create referrer ({0}). Details: {1}", ELogLevel.Error, referrer, exc.GetExceptionDetails());
                        //_referrerById.AddOrUpdate(0, referrer, (key, value) => referrer);
                    }
                }
            }
            return _idCr;
        }

    }
}