﻿using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using Curse.ServiceModels.Caching;
using System.Data.SqlClient;
using Curse.ServiceModels.Configuration;
using Curse.DownloadStatisticService.Models;
using Curse.Extensions;
using System.Runtime.CompilerServices;

namespace Curse.DownloadStatisticService.Caching
{
    public class UserAgentCache : IncrementalCache<UserAgent>
    {
        ConcurrentDictionary<int, string> _userAgentById = new ConcurrentDictionary<int, string>();

        static UserAgentCache _instance = new UserAgentCache();
        public static UserAgentCache Instance { get { return _instance; } }
        public UserAgentCache() : base("DownloadStatistics", "spGetUserAgents") { }

        public override bool UpdateCache()
        {
            using (var conn = new SqlConnection(DatabaseConfiguration.Instance["DownloadStatistics"].ConnectionString))
            {
                var cmd = new SqlCommand("SELECT ID, UserAgent FROM DownloadLogUserAgent", conn);

                try
                {
                    conn.Open();
                    using (var reader = cmd.ExecuteReader())
                    {
                        while (reader.Read())
                        {
                            int id = reader.GetInt32(reader.GetOrdinal("ID"));
                            string userAgent = reader.GetString(reader.GetOrdinal("UserAgent"));

                            _userAgentById.AddOrUpdate(id, userAgent, (key, value) => userAgent);
                        }
                    }
                }
                catch (Exception exc)
                {
                    Logger.Log("Unable to update the Referrer Cache. Details: {0}", ELogLevel.Error, exc.GetExceptionDetails());
                    return false;
                }
            }

            return true;
        }

        private static int _ua;
        public int GetIDByUserAgent(string userAgent)
        {
            if (userAgent == null) { return 0; }

            if (userAgent.Length > 512)
            {
                userAgent = userAgent.Substring(0, 512);
            }

            _ua = 0;
            _ua = _userAgentById.FirstOrDefault(p => p.Value == userAgent).Key;

            if (_ua == 0)
            {
                //_ua = CreateUserAgent(userAgent);
                    using (var conn = new SqlConnection(DatabaseConfiguration.Instance["DownloadStatistics"].ConnectionString))
                    {
                        var cmd = new SqlCommand("INSERT INTO DownloadLogUserAgent (UserAgent) VALUES (@UserAgent) SET @ID = SCOPE_IDENTITY()", conn);
                        cmd.Parameters.Add("UserAgent", System.Data.SqlDbType.VarChar).Value = userAgent;
                        cmd.Parameters.Add("ID", System.Data.SqlDbType.Int);
                        cmd.Parameters["ID"].Direction = System.Data.ParameterDirection.Output;

                        try
                        {
                            conn.Open();
                            cmd.ExecuteNonQuery();
                            _ua = (int)cmd.Parameters["ID"].Value;
                            _userAgentById.AddOrUpdate(_ua, userAgent, (key, value) => userAgent);
                        }
                        catch (Exception exc)
                        {
                            Logger.Log("Failed to Create UserAgent ({0}). Details: {1}", ELogLevel.Error, userAgent, exc.GetExceptionDetails());
                            //_userAgentById.AddOrUpdate(0, userAgent, (key, value) => userAgent);
                        }
                    }

            }

            return _ua;
        }

        private static int _uaCuad;
        public bool CheckUserAgentData(AddDownloadLogEntryMessage message, out string returnMessage)
        {
            string userAgent = String.Empty;
            if (String.IsNullOrEmpty(message.UserAgent))
            {
                returnMessage = "Success";
                return true;
            }
            else if (message.UserAgent.Length > 512)
            {
                userAgent = message.UserAgent.Substring(0, 512);
            }
            else
            {
                userAgent = message.UserAgent;
            }

            _uaCuad = 0;
            _uaCuad = _userAgentById.FirstOrDefault(p => p.Value == userAgent).Key;

            if (_uaCuad == 0)
            {
                //_uaCuad = CreateUserAgent(userAgent);
                using (var conn = new SqlConnection(DatabaseConfiguration.Instance["DownloadStatistics"].ConnectionString))
                {
                    var cmd = new SqlCommand("INSERT INTO DownloadLogUserAgent (UserAgent) VALUES (@UserAgent) SET @ID = SCOPE_IDENTITY()", conn);
                    cmd.Parameters.Add("UserAgent", System.Data.SqlDbType.VarChar).Value = userAgent;
                    cmd.Parameters.Add("ID", System.Data.SqlDbType.Int);
                    cmd.Parameters["ID"].Direction = System.Data.ParameterDirection.Output;

                    try
                    {
                        conn.Open();
                        cmd.ExecuteNonQuery();
                        _uaCuad = (int)cmd.Parameters["ID"].Value;
                        _userAgentById.AddOrUpdate(_uaCuad, userAgent, (key, value) => userAgent);
                    }
                    catch (Exception exc)
                    {
                        Logger.Log("Failed to Create UserAgent ({0}). Details: {1}", ELogLevel.Error, userAgent, exc.GetExceptionDetails());
                        //_userAgentById.AddOrUpdate(0, userAgent, (key, value) => userAgent);
                    }
                }

                if(_uaCuad == 0)
                {
                    returnMessage = "Failed to Create User Agent record.";
                    return false;
                }
            }
            returnMessage = "Success";
            return true;
        }
        
        private static int _idCua;   
        /// <summary>
        /// Input param: userAgent should not be longer than 512 chars! 
        /// <para>It does not get Substringed in this method so if you pass more than 512 this methid will return false!</para>
        /// </summary>
        /// <param name="userAgent">512 char MAX!</param>
        /// <returns>true if the insert was successful or if param was null</returns>
        private int CreateUserAgent(string userAgent)
        {
            _idCua = 0;
            if (userAgent != null)
            {
                using (var conn = new SqlConnection(DatabaseConfiguration.Instance["DownloadStatistics"].ConnectionString))
                {
                    var cmd = new SqlCommand("INSERT INTO DownloadLogUserAgent (UserAgent) VALUES (@UserAgent) SET @ID = SCOPE_IDENTITY()", conn);
                    cmd.Parameters.Add("UserAgent", System.Data.SqlDbType.VarChar).Value = userAgent;
                    cmd.Parameters.Add("ID", System.Data.SqlDbType.Int);
                    cmd.Parameters["ID"].Direction = System.Data.ParameterDirection.Output;

                    try
                    {
                        conn.Open();
                        cmd.ExecuteNonQuery();
                        _idCua = (int)cmd.Parameters["ID"].Value;
                        _userAgentById.AddOrUpdate(_idCua, userAgent, (key, value) => userAgent);
                    }
                    catch (Exception exc)
                    {
                        Logger.Log("Failed to Create UserAgent ({0}). Details: {1}", ELogLevel.Error, userAgent, exc.GetExceptionDetails());
                        //_userAgentById.AddOrUpdate(0, userAgent, (key, value) => userAgent);
                    }
                    
                }
            }
            return _idCua;
        }

    }
}