﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;
using System.Web.Script.Serialization;
using Curse.ServiceModels.Configuration;
using Curse.DownloadStatisticService.Caching;
using System.Net;
using Curse.ServiceModels.Exceptions;
using System.ServiceModel.Activation;
using System.Web.Script;

namespace Curse.DownloadStatisticService
{
    [ServiceBehavior(Name = "DownloadStatisticService", Namespace = "http://downloadstats.curseforge.com/", AddressFilterMode = AddressFilterMode.Any, ConcurrencyMode = ConcurrencyMode.Multiple, InstanceContextMode = InstanceContextMode.Single)]
    [AspNetCompatibilityRequirements(RequirementsMode = AspNetCompatibilityRequirementsMode.Allowed)]
    public class DownloadStatisticService : IDownloadStatisticService
    {
        object _startLock = new object();

        public DownloadStatisticService()
        {
            lock (_startLock)
            {
                var _config = ServiceConfiguration.Instance;
                #region Init Logger
                string logLevel = _config.Logging.LogLevel;
                switch (logLevel.ToLower())
                {
                    case "debug":
                        Logger.SetLogLevel = ELogLevel.Debug;
                        break;
                    case "access":
                        Logger.SetLogLevel = ELogLevel.Access;
                        break;
                    case "error":
                        Logger.SetLogLevel = ELogLevel.Error;
                        break;
                    case "info":
                        Logger.SetLogLevel = ELogLevel.Info;
                        break;
                    case "warning":
                        Logger.SetLogLevel = ELogLevel.Warning;
                        break;
                }
                Logger.SetAutoGrowthMegabytes = 50;
                Logger.SetLogPath = _config.Logging.LogPath;
                #endregion

                //Init Caches
                Logger.Log("Initializing Referrer Cache...", ELogLevel.Info);
                ReferrerCache.Instance.Initialize();
                Logger.Log("Initializing Referrer Cache complete", ELogLevel.Info);
                
                Logger.Log("Initializing UserAgent Cache...", ELogLevel.Info);
                UserAgentCache.Instance.Initialize();
                Logger.Log("Initializing UserAgent Cache complete", ELogLevel.Info);

                Logger.Log("Initializing File Cache...", ELogLevel.Info);
                FileCache.Instance.Initialize();
                Logger.Log("Initializing File Cache complete", ELogLevel.Info);

                Logger.Log("Initializing Project Cache...", ELogLevel.Info);
                ProjectCache.Instance.Initialize();
                Logger.Log("Initializing Project Cache complete", ELogLevel.Info);

                Logger.Log("Initializing DownloadEntryCache Cache...", ELogLevel.Info);
                DownloadLogEntryCache.Instance.Initialize();
                Logger.Log("Initializing DownloadEntryCache complete", ELogLevel.Info);

                Logger.Log("Service Started!", ELogLevel.Info);
            }
        }
        
        public bool Init()
        {
            //TODO: actually make this return something useful, like maybe the counts from the cache collections after they are built
            return (FileCache.Instance.GetByID(36005) != null);
        }

        public void AddDownloadLogEntry(AddDownloadLogEntryMessage message)
        {
            DownloadLogEntryCache.Instance.AddDownloadLogEntry(message);
        }

        public void AddDownloadLogEntries(Messages messages)
        {
            if (messages.Count <= 0)
            {
                ErrorData error = new ErrorData("No Data Recieved", 2001);
                throw new WebFaultException<ErrorData>(error, HttpStatusCode.BadRequest);
            }

            var errors = new StringBuilder();
            foreach (AddDownloadLogEntryMessage message in messages)
            {
                try
                {
                    DownloadLogEntryCache.Instance.AddDownloadLogEntry(message);
                }
                catch (Exception exc)
                {
                    errors.AppendLine(exc.Message);
                }
            }

            if(!string.IsNullOrEmpty(errors.ToString()))
            {
                Logger.Log("Error adding message to the message queue: {0}", ELogLevel.Error, errors.ToString());
            }
        }

        public void ProcessErrorLog()
        {
            DownloadLogEntryCache.Instance.ProcessErrorLogs();
        }

        public void ProcessErrorFiles()
        {
            DownloadLogEntryCache.Instance.ProcessErrorFiles();
        }

        public int GetQueueCount()
        {
            return DownloadLogEntryCache.Instance.GetQueueCount();
        }
    }    
}
