﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.ServiceModel.Web;
using System.Text;

namespace Curse.DownloadStatisticService
{
    [ServiceContract]
    public interface IDownloadStatisticService
    {

        [OperationContract]
        [WebGet]
        bool Init();

        [OperationContract]
        [WebInvoke(Method = "POST", ResponseFormat = WebMessageFormat.Json, UriTemplate = "addDownloadLogEntry")]
        void AddDownloadLogEntry(AddDownloadLogEntryMessage message);

        [OperationContract]
        [WebInvoke(Method = "POST", ResponseFormat = WebMessageFormat.Json, UriTemplate = "addDownloadLogEntries")]
        void AddDownloadLogEntries(Messages messages);

        [OperationContract]
        [WebInvoke(Method = "GET", ResponseFormat = WebMessageFormat.Json, UriTemplate = "getQueueCount")]
        int GetQueueCount();

        [OperationContract]
        [WebGet]
        void ProcessErrorLog();

        [OperationContract]
        [WebGet]
        void ProcessErrorFiles();

        
    }

    [Serializable]
    [DataContract]
    public class AddDownloadLogEntryMessage
    {
        [DataMember(Order = 1)]
        public long ID { get; set; }

        [DataMember(Order = 2)]
        public int FileID { get; set; }

        [DataMember(Order = 3)]
        public int ProjectID { get; set; }

        [DataMember(Order = 4)]
        public int GameID { get; set; }

        [DataMember(Order = 5)]
        public string Referrer { get; set; }

        [DataMember(Order = 6)]
        public string UserAgent { get; set; }

        [DataMember(Order = 7)]
        public string Date { get; set; }

        [DataMember(Order = 8)]
        public string IpAddress { get; set; }
    }


    [Serializable]
    [CollectionDataContract]
    [KnownType(typeof(AddDownloadLogEntryMessage))]
    public class Messages : List<AddDownloadLogEntryMessage>
    {
    }
}
